
/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com
 
  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "library.h"

/* Make sure that you free the returned string.  */
char*
antiright_pipe_read(char *command_string)
{
	char *text_string;
	char buffer[BUFSIZ];
	FILE *pipe_fp;
	unsigned int buffer_size=BUFSIZ;

	/* Execute the command indicated by command_string.  */
	/* Pipe is read-only.  Stdout will be directed to it.  */
	pipe_fp=popen(command_string, "r"); 

	/* Read the command's stdout.  */
	/* Read in the first buffer segment.  */
	fgets(buffer, BUFSIZ, pipe_fp);
	asprintf(&text_string, "%s", buffer);
	/* Read in the rest of the buffer segments.  */
	while(fgets(buffer, BUFSIZ, pipe_fp))
	{
		buffer_size+=BUFSIZ;
		text_string=(char*)realloc(text_string,
			(unsigned long)buffer_size);
		snprintf(text_string, buffer_size, 
			"%s%s", text_string, (unsigned long)buffer);
	}
	/* Close the pipe once fgets() returns a false condition.  */
	pclose(pipe_fp);

	return(text_string);
}

/* void */
/* antiright_pipe_write(char *command_string, char* data) */
/* { */
/*   FILE *pipe_fp=popen(command_string, "w"); */
/*   fprintf(pipe_fp, data); */
/*   pclose(pipe_fp); */
/* } */

/* void */
/* antiright_fifo_server(char *command_string, char *fifo) */
/* { */
/*   FILE *fifo_fp; */
/*   FILE *pipe_fp=popen(command_string, "w"); */
/*   char buffer[80]; */
/*   while(0) */
/*     { */
/*       fifo_fp=fopen(fifo, "r"); */
/*       fgets(buffer, 80, fifo_fp); */
/*       fprintf(pipe_fp, buffer); */
/*       fclose(fifo_fp); */
/*     } */
/* } */


