/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

extern char *gsh_geometry;

void
gsh_set_geometry()
{
	assert(gsh_geometry);
	gtk_window_parse_geometry(GTK_WINDOW(gsh_window), 
		gsh_geometry);
}
void
gsh_check_and_set_geometry()
{
	if(gsh_geometry!=NULL)
	{	
		gsh_set_geometry();
		free(gsh_geometry);
	}
	else
	{
		asprintf(&gsh_geometry, "500x300");
		gsh_set_geometry();
		free(gsh_geometry);
	}

}

GtkWidget *
gsh_create_main_window()
{
	GtkWidget *window;

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	g_signal_connect (window, "delete-event",
		G_CALLBACK (gtk_main_quit), NULL);
  	g_signal_connect (window, "destroy",
		G_CALLBACK (gtk_main_quit), NULL); 

	return(window);		
}

void
gsh_init(int *argc, char ***argv)
{
	gtk_init(argc, argv);
	gsh_window=gsh_create_main_window();
}

