/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

GtkWidget *scrolled_window;
gboolean gsh_dont_scroll=FALSE;

void
gsh_setup_scrolled_window()
{
	scrolled_window=gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(
		GTK_SCROLLED_WINDOW(scrolled_window),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type(
		GTK_SCROLLED_WINDOW(scrolled_window),
		GTK_SHADOW_OUT);
	gtk_container_add(GTK_CONTAINER(gsh_window), 
		scrolled_window);
	gtk_widget_show(scrolled_window);

}

void
gsh_setup_containers()
{
 	gsh_hbox = gtk_hbox_new(FALSE, 2);
	
	if(!gsh_dont_scroll)
	{
		gsh_setup_scrolled_window();
		gtk_scrolled_window_add_with_viewport(
			GTK_SCROLLED_WINDOW(scrolled_window), 
			gsh_hbox);
	}
	else
	{
		gtk_container_add(GTK_CONTAINER(gsh_window),
			gsh_hbox);
	}

 gtk_widget_show(gsh_hbox);
 gsh_vbox = gtk_vbox_new(FALSE, 2);
 gtk_container_add(GTK_CONTAINER(gsh_hbox), gsh_vbox);
 gtk_widget_show(gsh_vbox);
}



