/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gshterm.h"

extern char *gsh_geometry;

int
main(int argc, char **argv)
{
	char *script_name;
	GtkWidget *terminal;

	gsh_init(&argc, &argv);

	terminal=gshterm_setup_terminal();

	script_name=gshterm_command_script(
		gshterm_construct_command(argc, argv));

	gsh_check_and_set_geometry();

#ifdef DEBUG	
	puts(gsh_geometry);
#endif /* DEBUG */

	g_signal_connect(G_OBJECT(terminal), "child-exited",
		G_CALLBACK(gshterm_exit_cb), script_name);

	/* SCRIPT_NAME is left allocated as it is needed
	   by the exit callback.  */

	vte_terminal_fork_command(
		VTE_TERMINAL(terminal), script_name, NULL, NULL, NULL,
		TRUE, TRUE, TRUE);

	gtk_widget_show(gsh_window);

	gtk_main();

	return(0);
}

