/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

gboolean gsh_updater_defined=FALSE;
unsigned int gsh_update_period=1000;

void
gsh_dynamic_label(char *command)
{
 if (gsh_updater_defined == FALSE)
 {
  gsh_label = gtk_label_new("Dynamic Label");
  gtk_label_set_selectable(GTK_LABEL(gsh_label), TRUE);
  gsh_manage(gsh_label);
  gsh_updater(command);
  g_timeout_add(gsh_update_period, gsh_updater, command);
  gsh_updater_defined = TRUE;
 }
 else
 {
  errno = 1;
  g_warning("%s: %d: Attempt to define multiple dynamic labels: %s",
	    __FILE__, __LINE__, g_strerror(errno));
 }
}

gint
gsh_updater(gpointer data)
{
 char           *results;
 char		*markup;
 
 results = antiright_pipe_read(data);
 markup=g_markup_printf_escaped("<span size=\"small\"><tt>%s</tt></span>", 
	results);
 free(results);
 gtk_label_set_markup(GTK_LABEL(gsh_label), markup);
 g_free(markup);
 return (TRUE);
}

