/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

extern unsigned int gsh_rows;
extern unsigned int gsh_row;

void
gsh_command_button(char *command)
{
 char           *label_text;
 label_text = antiright_beautified_label(command);
 gsh_button = gtk_button_new_with_label(label_text);
 free(label_text);
 g_signal_connect(G_OBJECT(gsh_button), "clicked",
		  G_CALLBACK(system_cb), command);
 gsh_manage(gsh_button);
}

void
gsh_image_button(char *command, char *filename)
{
	GtkWidget *image;
	image=gtk_image_new_from_file(filename);
	gsh_command_button(command);
	gtk_button_set_image(GTK_BUTTON(gsh_button), image);
}

void
gsh_manage(GtkWidget *widget)
{
 gsh_check_row();
 gtk_container_add(GTK_CONTAINER(gsh_vbox), widget);
 gtk_widget_show(widget);
 gsh_row++;
#ifdef DEBUG
 printf("gsh_row: %d, gsh_rows: %d\n", gsh_row, gsh_rows);
#endif
}

