/*
 * miscellaneous glibc extending functions
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002 Roland Stigge
 *
 */

#ifndef _ANT_UTIL_H
#define _ANT_UTIL_H

#include "config.h"

/* regular GNU system includes */
#ifdef HAVE_SYS_TIME_H
  #include <sys/time.h>
#endif
#include <time.h>

#define SHORT_INTERVAL 10000
/* 10 milliseconds */

extern int debug;

int timeval_subtract (struct timeval *result,
		      struct timeval *x,
		      struct timeval *y);
void ant_sleep(int usecs);
char *un_vanity(char *s);
char *timediff_str(time_t time1, time_t time0);
char *ltostr(long int i);
void execute(char *command);
char *get_homedir();
int touch_dotdir();
int substitute(char **s, char *x, char *y);

#endif /* util.h */
