%{
/*
 * option file parser
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002 Roland Stigge
 *
 */

/* redefine symbols to allow multiple parsers in same executable */
#include "optionsredefines.h"

/* type for semantic values of symbols: malloc'ed strings */
#define YYSTYPE char *

/* location type: line number */
#define YYLTYPE int

/* default action for locations (when grammar rule actions "callback") */
#define YYLLOC_DEFAULT(Current, Rhs, N) ;

/* let yyparse() accept one argument of type void * */
#define YYPARSE_PARAM session

/* regular GNU system includes */
#include <stdio.h>
#include <stdlib.h>

/* own header files */
#include "util.h"
#include "settings.h"

int yylex (void);
void yyerror(const char *message);

/* line number */
YYLTYPE yylloc = 1;
%}

/* terminal symbols */
%token OPT_TOKEN_WORD
%token OPT_TOKEN_NUMBER
%token OPT_TOKEN_STRING
%token OPT_TOKEN_EQUALS

%%
settings   :
           | settings line
;

line       : '\n'
           | OPT_TOKEN_WORD '\n'
               { settings_option_set(session, $1, "1");
	         free($1);
	       }
           | OPT_TOKEN_WORD OPT_TOKEN_EQUALS values '\n'
	       { settings_option_set(session, $1, $3);
		 free($1);
		 free($3);
	       }
           | error '\n'
             { if (debug)
	         fprintf(stderr,
		         "Warning: "
			 "Parsing option file:%d, recovering after error.\n",
			 @1);
	     }
;

values     : value
           | values value
               { if (asprintf(&$$, "%s %s", $1, $2) < 0) { /* allocated? */
		   fprintf(stderr, "Warning: "
			   "Couldn't allocate memory for compound value.\n");
		   $$ = $1;
		   free($2);
	         } else { /* successful: free old strings */
		   free($1);
		   free($2);
		 }
	       }
;

value      : OPT_TOKEN_WORD
           | OPT_TOKEN_NUMBER
           | OPT_TOKEN_STRING
;

%%

/*
 * callback for yyparse(), (also) called on errors (hopefully) handled
 * by error token actions in grammar, but not if errors occur to
 * often (bison needs 3 "correct" tokens to recover)
 */
void yyerror(const char *message) {
  if (debug)
    fprintf(stderr,
	    "Warning: Parsing option file:%d: %s.\n", yylloc, message);
}
