/*
 * The key pad
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002 Roland Stigge
 *
 */

/* regular GNU system includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* GTK */
#include <gtk/gtk.h>

/* own header files */
#include "session.h"
#include "isdn.h"

/* graphical symbols */
#include "backspace.xpm"
#include "redial.xpm"
#include "mute.xpm"

/*
 * called when button in key pad clicked (except mute)
 */
static void controlpad_button_cb(GtkWidget *button, gpointer data) {
  struct session_t *session = (struct session_t *) data;
  char c[] = {*(char *) gtk_object_get_data(GTK_OBJECT(button), "desc"), '\0'};
  char *temp;

  switch (session->state) {
  case STATE_READY: /* manipulate dial box */
    if ((*c >= '0' && *c <= '9') || *c == '*' || *c == '#') { /* new char */
      gtk_entry_append_text(GTK_ENTRY(GTK_COMBO(session->dial_number_box)
				      ->entry), c);
    } else if (*c == 'B') { /* clear one byte (Backspace) */
      temp = strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(
				       session->dial_number_box)->entry)));
      if (strlen(temp) > 0) {
	temp[strlen(temp) - 1] = 0;
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(session->dial_number_box)
				     ->entry), temp);
      }
      free(temp);
    } else if (*c == 'C') { /* clear entry */
      gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(session->dial_number_box)
				   ->entry), "");
    } else if (*c == 'R') { /* Redial from history */
      do {
	temp = g_list_nth_data(session->dial_number_history,
			       session->dial_number_history_pointer);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(session->dial_number_box)
				     ->entry), temp);
	if (session->dial_number_history_pointer <
	    session->dial_number_history_maxlen)
	  session->dial_number_history_pointer++;
	if (session->dial_number_history_pointer ==
	    session->dial_number_history_maxlen)
	  session->dial_number_history_pointer = 0;
      } while (*temp == '\0' && session->dial_number_history_pointer != 0);
    }
    gtk_widget_grab_focus(GTK_WIDGET(GTK_COMBO(session->dial_number_box)
				     ->entry));
    break;
  case STATE_CONVERSATION: /* touchtones */
    if ((*c >= '0' && *c <= '9') || *c == '*' || *c == '#') { /* new tt */
#define TOUCHTONE_LENGTH 0.1
      session->touchtone_countdown_isdn = TOUCHTONE_LENGTH * ISDN_SPEED;
      session->touchtone_countdown_audio =
	TOUCHTONE_LENGTH * session->audio_speed_out;
      session->touchtone_index = 
	*c == '*' ? 9 : *c == '0' ? 10 : *c == '#' ? 11 : *c - '1';
    }
    break;
  default: /* other states */
    ;
  }
}

/*
 * called when mute button in key pad clicked
 */
static void controlpad_mute_cb(GtkWidget *button _U_, gpointer data) {
  struct session_t *session = (struct session_t *) data;

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(
					  session->mute_button))) { /* muted */
    session->option_muted = 1;
    gtk_widget_show(session->muted_warning);
  } else { /* unmuted */
    session->option_muted = 0;
    gtk_widget_hide(session->muted_warning);
  }
}

/*
 * The key pad etc.
 */
GtkWidget *controlpad_new(struct session_t *session) {
  char *labels[4][4] = {{"1", "2", "3", "B"},
			{"4", "5", "6", "C"},
			{"7", "8", "9", "R"},
			{"*", "0", "#", "M"}};
  GtkWidget *frame;
  GtkWidget *hbox;
  GtkWidget *table;
  GtkWidget *button;

  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkStyle *style;
  GtkWidget *pixmapwid;

  GtkTooltips *tooltips;

  int i, j;

  tooltips = gtk_tooltips_new();
  /* tooltips are often grey by default and have to be set up with a gtkrc
     file:

     style "gtk-tooltips-style" {
             bg[NORMAL] = "#ffffc0"
     }
     widget "gtk-tooltips" style "gtk-tooltips-style"
   */

  frame = gtk_frame_new("Control");
  gtk_container_set_border_width(GTK_CONTAINER(frame), 8);

  hbox = gtk_hbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
  gtk_container_add(GTK_CONTAINER(frame), hbox);
  gtk_widget_show(hbox);

  table = gtk_table_new(4, 3, FALSE);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_box_pack_start(GTK_BOX(hbox), table, TRUE, FALSE, 5);
  gtk_widget_show(table);

  for (i = 0; i < 4; i++) { /* columns */
    for (j = 0; j < 4; j++) { /* rows */
      if (i == 3 && j == 3) { /* mute  */
	button = gtk_toggle_button_new();
	gtk_tooltips_set_tip(tooltips, button, "Mute microphone", NULL);
	style = gtk_widget_get_style(session->main_window);
	pixmap = gdk_pixmap_create_from_xpm_d(session->main_window->window,
					      &mask,
					      &style->bg[GTK_STATE_NORMAL],
					      (gchar **) mute_xpm);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_container_add(GTK_CONTAINER(button), pixmapwid);
	gtk_widget_show(pixmapwid);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),
				     session->option_muted);
	session->mute_button = button;
	gtk_signal_connect(GTK_OBJECT(button), "toggled",
			   GTK_SIGNAL_FUNC(controlpad_mute_cb), session);
      } else {
	if (i == 3 && j == 0) { /* backspace icon */
	  button = gtk_button_new();
	  gtk_tooltips_set_tip(tooltips, button, "Backspace", NULL);
	  style = gtk_widget_get_style(session->main_window);
	  pixmap = gdk_pixmap_create_from_xpm_d(session->main_window->window,
						&mask,
						&style->bg[GTK_STATE_NORMAL],
						(gchar **) backspace_xpm);
	  pixmapwid = gtk_pixmap_new(pixmap, mask);
	  gtk_container_add(GTK_CONTAINER(button), pixmapwid);
	  gtk_widget_show(pixmapwid);
	} else if (i == 3 && j == 2) { /* redial icon */
	  button = gtk_button_new();
	  gtk_tooltips_set_tip(tooltips, button, "Redial", NULL);
	  style = gtk_widget_get_style(session->main_window);
	  pixmap = gdk_pixmap_create_from_xpm_d(session->main_window->window,
						&mask,
						&style->bg[GTK_STATE_NORMAL],
						(gchar **) redial_xpm);
	  pixmapwid = gtk_pixmap_new(pixmap, mask);
	  gtk_container_add(GTK_CONTAINER(button), pixmapwid);
	  gtk_widget_show(pixmapwid);
	} else { /* icon with letter */
	  button = gtk_button_new_with_label(labels[j][i]);
	  if (i == 3 && j == 1)
	    gtk_tooltips_set_tip(tooltips, button, "Clear number", NULL);
	}
	/* connect callback to widget */
	gtk_object_set_data(GTK_OBJECT(button), "desc", labels[j][i]);
	gtk_signal_connect(GTK_OBJECT(button), "pressed",
			   GTK_SIGNAL_FUNC(controlpad_button_cb), session);
      }
      gtk_table_attach_defaults(GTK_TABLE(table), button, i, i + 1, j, j + 1);
      gtk_object_set(GTK_OBJECT(button), "width", i < 3 ? 30 : 20, NULL);
      gtk_widget_show(button);
    }
    gtk_table_set_col_spacing(GTK_TABLE(table), i, i < 2 ? 5 : 15);
  }

  return frame;
}

/* called when control pad state check button is toggled */
void controlpad_toggle_cb(GtkWidget *widget _U_,
			  gpointer data, guint action _U_) {
  struct session_t *session = (struct session_t *) data;

  if (GTK_CHECK_MENU_ITEM (session->controlpad_check_menu_item)->active) {
    gtk_widget_show(session->controlpad);
    session->option_show_controlpad = 1;
  } else {
    gtk_widget_hide(session->controlpad);
    session->option_show_controlpad = 0;
  }
}
