/*
 * client functionality:
 *   * let a process issue commands (dial)
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002 Roland Stigge
 *
 */

/* regular GNU system includes */
#include <stddef.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/un.h>

/* own header files */
#include "client.h"
#include "server.h"
#include "util.h"

/*
 * (try to) connect to server and issue call command
 *
 * returns 0 on success, -1 otherwise
 */
int client_make_call(char *number) {
  int sock;
  struct sockaddr_un local_name;
  size_t size;
  char *filename;
  int bytes;
  char *msg;

  sock = socket(PF_LOCAL, SOCK_STREAM, 0);
  if (sock < 0) {
    perror("client: local socket()");
    return -1;
  }

  filename = server_local_socket_name();

  local_name.sun_family = AF_LOCAL;
  strncpy(local_name.sun_path, filename, sizeof(local_name.sun_path));
  size = SUN_LEN(&local_name);

  if (connect(sock, (struct sockaddr *) &local_name, sizeof(local_name)) < 0) {
    perror("client: local connect()");
    return -1;
  }
  
  if (asprintf(&msg, "%c%s", LOCAL_MSG_CALL, number) < 0) {
    fprintf(stderr, "asprintf error");
    return -1;
  }
  bytes = write(sock, msg, 1 + strlen(number) + 1);
  if (bytes < 0) {
    perror("socket write");
    return -1;
  }
  free(msg);

  close(sock);
  free(filename);
  return 0;
}
