/*
 * miscellaneous glibc extending functions
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002 Roland Stigge
 *
 */

#ifndef _ANT_UTIL_H
#define _ANT_UTIL_H

/* regular GNU system includes */
#include <sys/time.h>
#include <time.h>

#define SHORT_INTERVAL 10000
/* 10 milliseconds */

extern int debug;

int timeval_subtract (struct timeval *result,
		      struct timeval *x,
		      struct timeval *y);
void ant_sleep(int usecs);
char *un_vanity(char *s);
char *timediff_str(time_t time1, time_t time0);
char *ltostr(long int i);

#endif /* util.h */
