/*
 * miscellaneous glibc extending functions
 *
 * This file is part of ANT (Ant is Not a Telephone)
 *
 * Copyright 2002 Roland Stigge
 *
 */

#include <sys/time.h>
#include <time.h>

#include "util.h"

/* util.h will be included everywhere needed so the right place is here */
int debug = 0;

/* Subtract the `struct timeval' values X and Y,
 *    storing the result in RESULT.
 *    Return 1 if the difference is negative, otherwise 0.
 */
int timeval_subtract (struct timeval *result,
		      struct timeval *x,
		      struct timeval *y) {
    /* Perform the carry for the later subtraction by updating y. */
    if (x->tv_usec < y->tv_usec) {
      int nsec = (y->tv_usec - x->tv_usec) / 1000000 + 1;
      y->tv_usec -= 1000000 * nsec;
      y->tv_sec += nsec;
    }
    if (x->tv_usec - y->tv_usec > 1000000) {
      int nsec = (x->tv_usec - y->tv_usec) / 1000000;
      y->tv_usec += 1000000 * nsec;
      y->tv_sec -= nsec;
    }

    /* Compute the time remaining to wait.
       tv_usec is certainly positive. */
    result->tv_sec = x->tv_sec - y->tv_sec;
    result->tv_usec = x->tv_usec - y->tv_usec;

    /* Return 1 if result is negative. */
    return x->tv_sec < y->tv_sec;
}

/* sleeps usecs microseconds (will be interrupted by signals) */
void ant_sleep(int usecs) {
  struct timespec requested;
  struct timespec remaining;

  requested.tv_sec = 0;
  requested.tv_nsec = usecs * 1000;
  nanosleep(&requested, &remaining);
}
