// -*- C++ -*-
/***************************************************************************
                           libaudiostream
                          --------------------
    begin                : Sat 9 Mar 2002
    copyleft             : Giuseppe "denever" Martino
    email                : denever@users.sourceforge.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the Free Software            *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *                                                                         *
 ***************************************************************************/


#ifndef WAVE_H
#define WAVE_H

namespace libaudiostream
{
    typedef double* samples_buffer_pointer;
    typedef double sample_type;
    typedef unsigned int size_type;
    
    class Wave
    {
    protected:
	size_type m_duration;

    public:
	Wave();
	Wave(size_type);
	Wave(const Wave&);
	virtual ~Wave();
	
	virtual sample_type wave_form(size_type)=0;
	size_type get_duration();
    };
    
    class SineWave:public Wave
    {
    protected:
	unsigned int m_samplerate;
	sample_type m_amplitude;
	double m_frequency;
	double m_phase;
	
    public:
	SineWave();
	SineWave(unsigned int, size_type, sample_type, double, double);
	SineWave(const SineWave&);
	~SineWave();
	
	double wave_form(size_type);
	
	double get_phase();
	void set_phase(double);
    };
    
    class Pause: public Wave
    {
    public:
	Pause(size_type);
	sample_type wave_form(size_type);
    };
    
    class SampledWave: public Wave
    {
    private:
	samples_buffer_pointer m_samples;
	unsigned int pos;
    public:
	SampledWave();
	SampledWave(size_type);
	~SampledWave();

	void resize(unsigned int);
	void add_sample(double);
	sample_type wave_form(size_type);
	samples_buffer_pointer wave_form();
    };
}
#endif //WAVE_H
