/***************************************************************************
                         librandom part of Aldo
                          --------------------
    begin                : Sun May 6 2001
    copyleft             : Giuseppe "denever" Martino
    email                : denever@users.sourceforge.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the Free Software            *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *                                                                         *
 ***************************************************************************/

#include "random.h"

#include <limits>

#include <time.h>

using namespace std;
using namespace librandom;

const unsigned long mult = 1234567821;

Random::Random()
{
    m_seed = time(0);
    m_count = time(0);
    randomize();
}

int Random::integer(int max)
{
    randomize();
    return( m_seed % numeric_limits<int>::max() );
}

int Random::integer(int min, int max)
{
    randomize();
    return ( min + m_seed % (max - min +1) );
}

double Random::real()
{
    randomize();
    return double(m_seed)/double( numeric_limits<unsigned long int>::max() );
}

inline void Random::randomize()
{
    m_count++;
    m_seed =  (mult * m_seed + 1) % numeric_limits<unsigned long int>::max();
    m_seed += mult*(m_seed % m_count);
}

int Random::ToC()
{
	randomize();
	return (m_seed % 2);
}
