/***************************************************************************
                           libaudiostream
                          --------------------
    begin                : Sat 9 Mar 2002
    copyleft             : Giuseppe "denever" Martino
    email                : denever@users.sourceforge.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the Free Software            *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *                                                                         *
 ***************************************************************************/

#include <cmath>
#include "wave.h"

using namespace std;
using namespace libaudiostream;

Wave::Wave():m_duration(0)
{}

Wave::Wave(size_type d):m_duration(d)
{}

Wave::Wave(const Wave& cpy)
{
    m_duration = cpy.m_duration;
}

Wave::~Wave()
{}

unsigned int Wave::get_duration()
{
    return m_duration;
}

SineWave::SineWave():m_samplerate(8000), m_amplitude(0), m_frequency(0), m_phase(0)
{}

SineWave::SineWave(unsigned int sr, size_type d, sample_type a, double f, double p):
    Wave(d), m_samplerate(sr), m_amplitude(a), m_frequency(f), m_phase(p)
{}

SineWave::SineWave(const SineWave& cpy)
{
    m_samplerate = cpy.m_samplerate;
    m_amplitude = cpy.m_amplitude;
    m_frequency = cpy.m_frequency;
    m_phase = cpy.m_phase;
}

double SineWave::wave_form(size_type t)
{
    m_phase += m_frequency*2*M_PI/m_samplerate;
    return sin(m_phase);
}

double SineWave::get_phase()
{
    return m_duration*m_frequency*2*M_PI/m_samplerate;
}

void SineWave::set_phase(double p)
{
    m_phase = p;
}

SineWave::~SineWave()
{}

Pause::Pause(size_type d):Wave(d)
{}

double Pause::wave_form(size_type t)
{
    return 0;
}

SampledWave::SampledWave():Wave(0),m_samples(0),pos(0)
{}


SampledWave::SampledWave(size_type d): Wave(d), m_samples(0), pos(0)
{
    m_samples = new double[d];
}

void SampledWave::resize(unsigned int d)
{
    m_duration = d;

    if(m_samples)
	delete [] m_samples;
    
    m_samples = new double[d];
}

void SampledWave::add_sample(sample_type sample)
{
    if(pos<m_duration)
    {
	m_samples[pos] = sample;
	pos++;
    }
}

sample_type SampledWave::wave_form(size_type t)
{
    return m_samples[t];
}

samples_buffer_pointer SampledWave::wave_form()
{
    return m_samples;
}

SampledWave::~SampledWave()
{
    if(m_samples)
	delete [] m_samples;
}
