// -*- C++ -*-
/***************************************************************************
                             libmenu
                          --------------------
    begin                : Sun May 6 2001
    copyleft             : Giuseppe "denever" Martino
    email                : denever@users.sourceforge.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the Free Software            *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *                                                                         *
 ***************************************************************************/

#include <string>
#include <vector>

#pragma interface

template <class T>
class Choice
{
private:
    std::string m_caption;
    T m_return_value;

public:
    Choice();
    Choice(std::string, T);

    std::string caption() const;
    T selected() const;
};

template <class T>
class Dialog
{
private:
    std::string m_title;
    std::string m_prompt;
    std::vector< Choice<T> > m_choices;

public:
    Dialog();
    Dialog(std::string, std::string);
    Dialog(const Dialog&);

    void add_choice(std::string, T);
    T show();
};

template <class T>
Choice<T>::Choice():m_caption("Empty"),m_return_value(0)
{}

template <class T>
Choice<T>::Choice(std::string c, T v): m_caption(c), m_return_value(v)
{}

template <class T>
std::string Choice<T>::caption() const
{
    return m_caption;
}

template <class T>
T Choice<T>::selected() const
{
    return m_return_value;
}

template <class T>
Dialog<T>::Dialog(): m_title("Dialog"), m_prompt("Prompt:")
{}

template <class T>
Dialog<T>::Dialog(std::string t, std::string p):m_title(t), m_prompt(p)
{}

template <class T>
Dialog<T>::Dialog(const Dialog& copy)
{
    m_title = copy.m_title;
    m_prompt = copy.m_prompt;
    m_choices = copy.m_choices;
}

template <class T>
void Dialog<T>::add_choice(std::string c, T r)
{
    m_choices.push_back(Choice<T>(c,r));
}

template <class T>
T Dialog<T>::show()
{
    std::cout<<m_title<<std::endl;

    unsigned char i=49;

    for(unsigned int it=0; it<m_choices.size(); it++, i++)
    {
	std::cout<<"\t"<<i<<": "<<m_choices.at(it).caption()<< std::endl;

	if(i == 57)
	    i = 96;
    }
    
    unsigned int choice = 0;
    do
    {
	std::cout<<endl<<m_prompt;

	std::string trash;
	std::cin>>trash;

	choice = int(trash[0]) - 49;

	if(choice > 47)
	    choice -= 39;

    }
    while( choice > m_choices.size()-1 );

    return m_choices.at(choice).selected();
}
