// -*- C++ -*-
/***************************************************************************
                             libaudiostream
                          --------------------
    begin                : Sat 9 Mar 2002
    copyleft             : Giuseppe "denever" Martino
    email                : denever@users.sourceforge.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the Free Software            *
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA*
 *                                                                         *
 ***************************************************************************/

#ifndef EXCEPTION_H
#define EXCEPTION_H

namespace libaudiostream
{
    struct Open_device_error
    {
	const char* m_device;
    public:
	Open_device_error(const char* d)
	    : m_device(d)
	{}
    };
    
    struct Rate_error
    {
	unsigned int m_set_rate;
	unsigned int m_get_rate;

    public:
	Rate_error(unsigned int s, unsigned int g)
	    : m_set_rate(s), m_get_rate(g)
        {}
    };
        
    struct Format_error
    {
	unsigned int m_format;
    public:
	Format_error(unsigned int f)
	    : m_format(f)
        {}
    };
    
    struct Fragment_error
    {
	unsigned int m_fragment_size;
    public:
	Fragment_error(unsigned int f)
	    : m_fragment_size(f)
	{}
    };

    struct Stereo_error
    {
	unsigned int m_stereo;
    public:
	Stereo_error(unsigned int s)
	    : m_stereo(s)
	{}
    };
}

#endif // EXCEPTION_H








