// -*- C++ -*-
/***************************************************************************
                           libaudiostream
                          --------------------
    begin                : Sat 9 Mar 2002
    copyleft             : Giuseppe "denever" Martino
    email                : denever@users.sourceforge.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the Free Software            *
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA*
 *                                                                         *
 ***************************************************************************/

#ifndef AUDIOSTREAM_H
#define AUDIOSTREAM_H

#include <string>
#include "wave.h"

namespace libaudiostream
{
    class oastream
    {
    private:
	int m_audio;
	std::string m_device;
	unsigned int m_sample_rate;
	unsigned int m_format;
	unsigned int m_sample_size;
	unsigned int m_fragment_size;
	unsigned int m_bytes_writed;
	bool m_stereo;

	void setup_soundcard();
	void get_soundcard_buffer_info();
	void get_soundcard_count_info();
	
	void play_8bits(Wave&);
	void play_16bits(Wave&);
	void play_32bits(Wave&);

	unsigned int m_free_fragments;
	unsigned int m_total_fragments;
	unsigned int m_free_bytes;
	
	unsigned int m_bytes_processed;
	unsigned int m_fragments_processed;

    public:
	oastream();

	oastream(std::string, unsigned int, unsigned int, unsigned int = 1, unsigned int = 512, bool =false);

	oastream(const oastream&);
	
	~oastream();
	
	oastream& operator<<(Wave&);

	inline std::string device() const
	{
	    return m_device;
	}
	
	inline unsigned int sample_rate() const
	{
	    return m_sample_rate;
	}

	inline unsigned int sample_size() const
	{
	    return m_sample_size;
	}
    };
}

#endif //AUDIOSTREAM_H
