.\" Process this file with
.\" groff -man -Tutf8 interactive_lua.en.man
.\"
.
.\" Macros .TQ .EX .EE taken from groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.\" Continuation line for .TP header.
.de TQ
.  br
.  ns
.  TP \\$1\" no doublequotes around argument!
..
.
.\" Start example.
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" End example.
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.TH "interactive_lua.lua" 1 2012-07-24 AKFAvatar
.
.SH NAME
interactive_lua.lua \- Lua interaktiv mit AKFAvatar verwenden
.
.SH SYNTAX
.BI interactive_lua.lua
.
.SH BESCHREIBUNG
Lua interaktiv mit AKFAvatar verwenden.
.PP
Man kann es zum Beispiel als Taschenrechner verwenden.
Wenn man eine Zeile mit einem Gleichheitszeichen (\[Bq]=\[lq]) einleitet,
wird das Ergebnis des folgenden Ausdrucks angezeigt.
Zum Beisiel, wenn man \[Bq]=10/4\[lq] eingibt, gibt er \[Bq]2,5\[lq] aus.
.PP
Zu beachten ist, dass das Dezimalzeichen, welches angezeigt wird, abhngig von
den Sprach-Einstellungen ist.
Wenn man jedoch einen Dezimalbruch eingeben will, muss man die amerikanische
Notation mit einem Dezimal-Punkt verwenden!
.PP
Man kann seine eigenen Variablen definieren.
Zum Beispiel ein Megabyte ist 2^20 Bytes.
Man kann also \[Bq]MB=2^20\[lq] eingeben, und dann kann man das in eigenen
Berechnungen verwenden. Wenn man wissen will, wieviel 5 Megabytes in Bytes
sind, kann man \[Bq]=5*MB\[lq] eingeben, das Ergebnis ist dann
\[Bq]5242880\[lq].
Man mus auch darauf achten, dass bei Lua die Gro-/Klein-Schreibung wichtig
ist.
Das bedeutet, dass \[Bq]MB\[lq] und \[Bq]mb\[lq] unterschiedliche
Variablen sind.
.PP
Die Mglichkeit Zeilen mit einem Gleichheitszeichen einzuleiten ist eine
besondere Eigenschaft des interaktiven Programmes.
Es kann nicht in Skripten verwendet werden.
.PP
Die normale Eingabeaufforderung ist ein \[Bq]>\[lq].
Wenn man jedoch eine unvollstndinge Zeile eingibt, bekommt man eine andere
Eingabeaufforderung, nmlich \[Bq]>>\[lq].
Dann kann man seine Eingabe fortsetzen.
Wenn man versehentlich bei dieser Eingabeaufforderung landet, kann man
einfach <Enter> drcken.
Das verwirft die vorherige Eingabe.
.PP
Man kann auch seine eigenen Funktionen definieren.
Zum Beispiel:
.EX
  > function Kreisflaeche(radius)
  >> return radius^2 * math.pi
  >> end
  > =3 * Kreisflaeche(5)
  235.61944901923
.EE
.PP
Man kann jeden Lua-Befehl verwenden, einschlielich AKFAvatar-Befehlen.
Zum Beispiel kann man dem Avatar einen Namen geben:
.EX
  > avt.set_avatar_name("Hugo")
.EE
.PP
Oder, wenn man berhaupt keinen Avatar haben will:
.EX
  > avt.avatar_image("none")
.EE
.PP
Um einen weiblichen Avatar zu bekommen:
.EX
  > avt.avatar_image_file(avt.search("female_user.xpm"))
.EE
.PP
Man kann so viel mehr damit machen...
Einfach mal rumprobieren...
.PP
