.\" Process this file with
.\" groff -man -Tutf8 akfavatar-utf8.de.man
.\"
.
.\" Macros .TQ .EX .EE taken from groff an-ext.tmac
.\" Copyright (C) 2007, 2009 Free Software Foundation, Inc.
.\" You may freely use, modify and/or distribute this file.
.
.\" Continuation line for .TP header.
.de TQ
.  br
.  ns
.  TP \\$1\" no doublequotes around argument!
..
.
.\" Start example.
.de EX
.  nr mE \\n(.f
.  nf
.  nh
.  ft CW
..
.
.
.\" End example.
.de EE
.  ft \\n(mE
.  fi
.  hy \\n(HY
..
.
.TH "akfavatar.utf8" 3 2012-07-22 AKFAvatar
.
.SH NAME
akfavatar.utf8 \- Module fr UTF-8 Untersttzung in Lua-AKFAvatar
.
.SH SYNTAX
.PP
local utf8 = require "akfavatar.utf8"
.PP
.SH BESCHREIBUNG
Dieses Modul definiert Funktionen fr UTF-8 Strings.
Viele dieser Funktionen dienen als Ersatz fr Funktionen in Luas
String-Bibliothek.
.PP
UTF-8 ist eine Zeichen-Kodierung fr Unicode. Ein Zeichen kann mit einem bis
vier Byte kodiert sein. Darum wird eine besondere Behandlung erforderlich.
Die meisten Funktionen der String-Bibliothek von Lua knnen nmlich nur
mit Kodierungen mit einem Byte pro Zeichen umgehen.
.PP
.TP
.BI utf8.len( String )
Zhlt die Anzahl der Zeichen in einem UTF-8 kodierten
.IR String .
.br
.BR Hinweis :
Steuerzeichen und unsichtbare Zeichen werden auch gezhlt.
.PP
.TP
.BI utf8.sub( "String, Anfangszeichen [,Endzeichen]" )
Wie
.BR string.sub ,
aber fr UTF-8 Strings.
.IP
Gibt den Teilstring von
.IR Anfangszeichen " bis " Endzeichen
zurck.
Falls 
.IR Anfangszeichen " oder " Endzeichen
negativ sind, dann werden sie vom Ende des Strings gezhlt.
.br
Also, utf8.sub(s, 1, 3) gibt die ersten 3 Zeichen zurck,
whrend utf8.sub(s, -3) die letzten 3 Zeichen zurck gibt.
.PP
.TP
.BI utf8.char( ... )
Wie
.BR string.char ,
aber es akzeptiert hhere Werte
und gibt einen UTF-8 kodierten String zurck.
.PP
.TP
.BI utf8.codepoint( String )
Gibt den Codepoint des ersten Zeichens des
.IR String s
zurck.
.br
Im Falle eines Fehlers gibt es
.I nil
zurck
(aber das ist keine richtige Gltigkeitsprfung).
.PP
.TP
.BI utf8.codepoints( "String [,Anfangszeichen [,Endzeichen]]" )
Wie
.BR string.byte .
.br
Gibt die Unicode-Werte von
.IR Anfangszeichen " bis " Endzeichen
zurck.
.br
Wenn man nur das erste Zeichen bentigt, sollte man stattdessen
.B utf8.codepoint()
verwenden.
.PP
.TP
.BI utf8.characters( String )
Iterator fr die einzelnen Zeichen eines UTF-8 Strings.
.br
Ein Zeichen kann ein Einzelbyte oder Multibyte-String sein.
.IP
Anwendungsbeispiel:
.EX
  for c in utf8.characters(line) do print(utf8.codepoint(c)) end
.EE
.PP
.TP
.BI utf8.reverse( String )
Dreht einen UTF-8
.I String
um.
.br
.BR Hinweis :
Kombinationszeichen sind noch problematisch.
.PP
.TP
.BI utf8.rep( "String, n" )
Gibt den
.I "String n"
mal wiederholt zurck.
Dies ist nur ein Alias fr
.BR string.rep() .
.PP
.TP
.BI utf8.underlined( String )
Gibt den
.I String
unterstrichen zurck (Overstrike-Technik).
.PP
.TP
.BI utf8.bold( String )
Gibt den
.I String
fett gedruckt zurck (Overstrike-Technik).
.PP
.TP
.B utf8.bom
Byte Order Mark.
.br
Das wird bei UTF-8 zwar nicht bentigt,
wird aber manchmal als Signatur eingesetzt.
.PP
.TP
.BI utf8.check_bom( String )
berprft, ob der
.I String
mit einem UTF-8-BOM anfngt.
.PP
.TP
.BI utf8.check( String )
berprft, ob der
.I String
in UTF-8 kodiert ist.
.br
Es ist nur eine berprfung ob UTF-8 oder nicht,
es ist keine Gltigkeitsberprfung.
.br
.BR Hinweis :
reines ASCII ist auch gltiges UTF-8.
.PP
.TP
.BI utf8.check_unicode( String )
berprft den String auf Unicode-Kodierungen.
.br
Gibt eines von "UTF-8", "UTF-16BE", UTF-16LE", "UTF-32BE", "UTF-32LE"
zurck, oder
.IR nil ,
wenn keine Unicode Kodierung erkannt wird.
.PP
.TP
.BI utf8.from_ncr( String )
Ersetzt Numeric Character References (NCR) mit UTF-8 Zeichen.
.br
Zum Beispiel "&#8364;" (dezimal) oder "&#x20AC;" (hexadezimal) fr
das Euro Whrungszeichen.
.PP
.TP
.BI utf8.to_ncr( String )
Ersetzt nicht-ASCII Zeichen mit NCRs.
Das Ergebnis ist ein reiner ASCII-String, aber kodiert.
.PP
.TP
.BI utf8.from_latin1( String )
Konvertiert einen
.I String
von Latin-1 (ISO-8859-1) nach UTF-8.
.PP
.TP
.BI utf8.to_latin1( "String [,Ersatz]" )
Konvertiert einen UTF-8
.I String
nach Latin-1 (ISO-8859-1).
Zeichen, die nicht konvertiert werden knnen, werden durch den
.IR Ersatz -String
ersetzt,
oder durch "\\x1A" wenn kein
.IR Ersatz -String
angegeben ist.
.PP
.SH "SIEHE AUCH"
.BR lua-akfavatar (1)
.BR lua (1)
.BR lua-akfavatar-ref (3)
.BR akfavatar-graphic (3)
.BR akfavatar-term (3)
