/*
 * ISO-8859-16 (ISO Latin-10) support for AKFAvatar
 * Copyright (c) 2013 Andreas K. Foerster <info@akfoerster.de>
 *
 * This file is part of AKFAvatar
 *
 * AKFAvatar is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * AKFAvatar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "avtaddons.h"

static const struct avt_char_map map = {
  .start = 0xA1,.end = 0xFF,
  .table = {
	    0x0104,		// 0xA1
	    0x0105,		// 0xA2
	    0x0141,		// 0xA3
	    0x20AC,		// 0xA4
	    0x201E,		// 0xA5
	    0x0160,		// 0xA6
	    0x00A7,		// 0xA7
	    0x0161,		// 0xA8
	    0x00A9,		// 0xA9
	    0x0218,		// 0xAA
	    0x00AB,		// 0xAB
	    0x0179,		// 0xAC
	    0x00AD,		// 0xAD
	    0x017A,		// 0xAE
	    0x017B,		// 0xAF
	    0x00B0,		// 0xB0
	    0x00B1,		// 0xB1
	    0x010C,		// 0xB2
	    0x0142,		// 0xB3
	    0x017D,		// 0xB4
	    0x201D,		// 0xB5
	    0x00B6,		// 0xB6
	    0x00B7,		// 0xB7
	    0x017E,		// 0xB8
	    0x010D,		// 0xB9
	    0x0219,		// 0xBA
	    0x00BB,		// 0xBB
	    0x0152,		// 0xBC
	    0x0153,		// 0xBD
	    0x0178,		// 0xBE
	    0x017C,		// 0xBF
	    0x00C0,		// 0xC0
	    0x00C1,		// 0xC1
	    0x00C2,		// 0xC2
	    0x0102,		// 0xC3
	    0x00C4,		// 0xC4
	    0x0106,		// 0xC5
	    0x00C6,		// 0xC6
	    0x00C7,		// 0xC7
	    0x00C8,		// 0xC8
	    0x00C9,		// 0xC9
	    0x00CA,		// 0xCA
	    0x00CB,		// 0xCB
	    0x00CC,		// 0xCC
	    0x00CD,		// 0xCD
	    0x00CE,		// 0xCE
	    0x00CF,		// 0xCF
	    0x0110,		// 0xD0
	    0x0143,		// 0xD1
	    0x00D2,		// 0xD2
	    0x00D3,		// 0xD3
	    0x00D4,		// 0xD4
	    0x0150,		// 0xD5
	    0x00D6,		// 0xD6
	    0x015A,		// 0xD7
	    0x0170,		// 0xD8
	    0x00D9,		// 0xD9
	    0x00DA,		// 0xDA
	    0x00DB,		// 0xDB
	    0x00DC,		// 0xDC
	    0x0118,		// 0xDD
	    0x021A,		// 0xDE
	    0x00DF,		// 0xDF
	    0x00E0,		// 0xE0
	    0x00E1,		// 0xE1
	    0x00E2,		// 0xE2
	    0x0103,		// 0xE3
	    0x00E4,		// 0xE4
	    0x0107,		// 0xE5
	    0x00E6,		// 0xE6
	    0x00E7,		// 0xE7
	    0x00E8,		// 0xE8
	    0x00E9,		// 0xE9
	    0x00EA,		// 0xEA
	    0x00EB,		// 0xEB
	    0x00EC,		// 0xEC
	    0x00ED,		// 0xED
	    0x00EE,		// 0xEE
	    0x00EF,		// 0xEF
	    0x0111,		// 0xF0
	    0x0144,		// 0xF1
	    0x00F2,		// 0xF2
	    0x00F3,		// 0xF3
	    0x00F4,		// 0xF4
	    0x0151,		// 0xF5
	    0x00F6,		// 0xF6
	    0x015B,		// 0xF7
	    0x0171,		// 0xF8
	    0x00F9,		// 0xF9
	    0x00FA,		// 0xFA
	    0x00FB,		// 0xFB
	    0x00FC,		// 0xFC
	    0x0119,		// 0xFD
	    0x021B,		// 0xFE
	    0x00FF		// 0xFF
	    }
};


static const struct avt_charenc converter = {
  .data = (void *) &map,
  .decode = map_to_unicode,
  .encode = map_from_unicode
};


extern const struct avt_charenc *
avt_iso8859_16 (void)
{
  return &converter;
}
