#!/usr/bin/awk -f

# bdf2c - Convert bdf font into C99-code
# only for fixed-width fonts!
#
# Copyright (c) 2009,2011,2012 Andreas K. Foerster
# Copying and distribution of this file, with or without modification,
# are permitted in any medium without royalty provided the copyright
# notice and this notice are preserved.  This file is offered as-is,
# without any warranty.

BEGIN {
  width=height=top=baseline=started=comma=default_char=charoffset=maxchar = 0
  print "// automatically generated by bdf2c\n"
  }

/^FONT / { print "// " $0 }

/^COPYRIGHT / { print "// " $0 }

/^CHARS / { print "// " $0 }

/^DEFAULT_CHAR/ { default_char = $2 }

/^FONTBOUNDINGBOX/ { width = $2; height = $3; top = $4; baseline = $5 }

/^STARTCHAR / {
  if (started == 0)
    {
      print "\n#include <stddef.h>\n#include <stdint.h>\n"
      print "#define DEFAULT_CHAR " default_char
      print "\n#ifdef __cplusplus"
      print "extern \"C\" void *" prefix "get_font_char (int ch);"
      print "extern \"C\" void " prefix \
            "get_font_dimensions (int *width, int *height, int *baseline);"
      print "#else"
      print "extern void *" prefix "get_font_char (int ch);"
      print "extern void " prefix \
            "get_font_dimensions (int *width, int *height, int *baseline);"
      print "#endif"
      if (width <= 8)
        print "\nstatic const uint_least8_t font[] = {"
      else
        print "\nstatic const uint_least16_t font[] = {"
     started = 1
    }
  else print ""

  #print "/* " $2 " */"
  }

/^ENCODING / {
  table[$2] = charoffset++
  if (0+$2 > maxchar) maxchar = 0+$2
  }

/^BITMAP/, /^ENDCHAR/ {
  if (/^BITMAP/ || /^ENDCHAR/) next

  if (comma) { printf ",0x%s", $1 }
    else { printf "0x%s", $1; comma = 1 }
  }

function writetranstable(    i, blockstart)
{
  print "void *\n" prefix "get_font_char (int ch)"

  print "{"
  printf "  "

  blockstart = 0

  # we need the numbers in order
  for (i = 0; i <= maxchar; i++)
    {
      if (i in table)
        {
          if ((i+1) in table && table[i+1] == table[i] + 1)
            {
              if (blockstart == 0) blockstart = i
            }
          else
            {
              if (blockstart == 0)
                printf "if (ch == %#06X) return (void*) &font[%u];\n", \
                       i, (table[i] * height)
              else
                {
                  printf "if (ch <= %#06X && ch >= %#06X)", i, blockstart
                  printf " return (void*) &font[(ch-%u)*%u];\n",
                         (blockstart-table[blockstart]), height
                }
              printf "  else "
              blockstart = 0
            }
        }
    }

  print "return NULL;"
  print "}"
}

END {
  print "\n};\n"

  print "void"
  print prefix "get_font_dimensions " \
        "(int *width, int *height, int *baseline)"
  print "{"
  print "  if (width) *width = " width ";"
  print "  if (height) *height = " height ";"
  print "  if (baseline) *baseline = " height + baseline ";"
  print "}\n"

  writetranstable()
  }
