/*
 *   This file is part of AkariXB
 *   Copyright 2015-2019  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef STRINGLISTWIDGET_H
#define STRINGLISTWIDGET_H

#include <QWidget>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QListWidget>
#include <QToolButton>
#include <QInputDialog>
#include <QTextEdit>
#include <QPushButton>
#include <QMessageBox>

#include <QDebug>


class StringListWidget : public QWidget
{
    Q_OBJECT

public:
    explicit StringListWidget(bool forKeyValues, QWidget *parent = nullptr);
    ~StringListWidget();

    void setLowercaseItems(bool lowercaseItems);
    void setDuplicatesAllowed(bool duplicatesAllowed);

    void clearList();
    void addStringsToList(QStringList stringList);
    QStringList getStringsFromList();

    void addItemsToList(QVariantMap stringMap);
    QVariantMap getItemsFromList();

    bool stringExists(QString text);

    void enableRelevantButtons();


signals:


public slots:
    void addToList();
    void editItem();
    void removeFromList();

    void onRowChanged(int row);

    void updateItemText();


private:
    QHBoxLayout *m_mainLayout;
    QListWidget *m_listWidget;

    QVBoxLayout *m_buttonsLayout;
    QToolButton *m_addButton;
    QToolButton *m_editButton;
    QToolButton *m_removeButton;

    QTextEdit *m_itemTextEdit;
    QPushButton *m_updateButton;

    bool m_forKeyValues;
    bool m_lowercaseItems;
    bool m_duplicatesAllowed;
};

#endif // STRINGLISTWIDGET_H
