/*
 *   This file is part of AkariXB
 *   Copyright 2015-2018  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QApplication>
#include <QMenuBar>
#include <QMenu>
#include <QStatusBar>
#include <QSystemTrayIcon>

#include <QVBoxLayout>
#include <QListWidget>
#include <QStackedWidget>
#include <QLabel>
#include <QPushButton>
#include <QLineEdit>
#include <QTextBrowser>
#include <QSettings>
#include <QMessageBox>
#include <QResizeEvent>
#include <QDesktopServices>
#include <QDir>
#include <QTimer>

#include <QDebug>

#include <QXmppClient.h>
#include <QXmppMessage.h>
#include <QXmppMucManager.h>
#include <QXmppVersionManager.h>
#include <QXmppMessageReceiptManager.h>

#include <iostream>


#include "globalobject.h"
#include "connectiondialog.h"
#include "configdialog.h"


#include "generalmodule.h"
#include "roommodule.h"
#include "chatmodule.h"
#include "commandmodule.h"
#include "conversationmodule.h"
#include "activitymodule.h"
#include "identitymodule.h"
#include "logmodule.h"

#include "messagehandler.h"
#include "commandhandler.h"
#include "activityhandler.h"
#include "variableparser.h"


class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = nullptr);
    ~MainWindow();

    void createMenus();
    void createTrayIcon();
    void createStatusBarWidgets();
    void createDataDir();

    void setupXmppClient();
    void enableXmppDebug();

    void loadSettings();
    void saveSettings();

    void setStatusIconOnline(QXmppPresence::AvailableStatusType statusType,
                             bool isOnline);


public slots:
    void connectToServer(QString jid, QString password,
                         bool autoconnect, QString resource,
                         int priority);
    void autoConnectToServer();
    void onConnected();
    void disconnectFromServer();
    void onDisconnected();
    void onConnectionTimerAbort();
    void onStatusChanged(QXmppPresence presence);

    void processMessage(QXmppMessage message);
    void processPresence(QXmppPresence presence);
    void processIq(QXmppIq iq);

    void onNetworkError(QXmppClient::Error error);

    void setChatsTitle(int count);

    void visitWebsite();
    void visitBugTracker();
    void visitXmppOrg();
    void aboutAkariXB();

    void setTitleAndTrayInfo();
    void setStatusBarMessage(QString message);
    void showNotification(QString title, QString message);
    void trayControl(QSystemTrayIcon::ActivationReason reason);
    void toggleMainWindow(bool onStartup=false);
    void quitProgram();


protected:
    virtual void resizeEvent(QResizeEvent *event);
    virtual void closeEvent(QCloseEvent *event);


private:
    GlobalObject *m_globalObject;

    // Menus
    QMenu *sessionMenu;
    QAction *sessionConnectAction;
    QAction *sessionDisconnectAction;
    QAction *sessionQuitAction;

    QMenu *settingsMenu;
    QAction *settingsConfigAction;

    QMenu *helpMenu;
    QAction *helpWebsiteAction;
    QAction *helpBugTrackerAction;
    QAction *helpAboutXmppAction;
    QAction *helpAboutAction;


    QSystemTrayIcon *systrayIcon;
    QMenu *systrayMenu;
    QAction *trayTitleSeparatorAction;
    QAction *trayShowWindowAction;


    // GUI
    QWidget *mainWidget;
    QHBoxLayout *mainLayout;
    QListWidget *categoriesList;
    QStackedWidget *stackedWidget;

    QLabel *statusBarLabel;


    ConnectionDialog *connectionDialog;
    ConfigDialog *configDialog;

    GeneralModule *generalModule;
    RoomModule *roomModule;
    ChatModule *chatModule;
    CommandModule *commandModule;
    ConversationModule *conversationModule;
    ActivityModule *activityModule;
    IdentityModule *identityModule;
    LogModule *logModule;

    MessageHandler *messageHandler;
    CommandHandler *commandHandler;
    ActivityHandler *activityHandler;

    VariableParser *variableParser;

    QTimer *m_initialConnectionTimer;

    // XMPP
    QXmppClient *m_xmppClient;
    QXmppMucManager *m_mucManager;
    QXmppMessageReceiptManager *m_receiptManager;


    QString m_userJid;
    QString m_userPassword;
    bool m_userAutoconnect;
    QString m_userResource;
    int m_userPriority;

    bool m_disconnectedManually;
};

#endif // MAINWINDOW_H
