/*
 *   This file is part of AkariXB
 *   Copyright 2015-2018  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef GENERALMODULE_H
#define GENERALMODULE_H

#include <QWidget>
#include <QVBoxLayout>
#include <QFormLayout>
#include <QLabel>
#include <QPushButton>
#include <QTextBrowser>

#include <QDebug>


#include <QXmppClient.h>
#include <QXmppPresence.h>

#include "globalobject.h"

class GeneralModule : public QWidget
{
    Q_OBJECT

public:
    explicit GeneralModule(GlobalObject *globalObject, QWidget *parent = 0);
    ~GeneralModule();

    void setInfoMessage(QString message);
    void setConnecting();
    void addPresence(QXmppPresence presence);


signals:
    void connectionRequested();
    void disconnectionRequested();


public slots:
    void onConnected();
    void onDisconnected();

    void onStatusChanged(QXmppPresence presence);


private:
    QVBoxLayout *mainLayout;
    QFormLayout *formLayout;

    QLabel *infoLabel;

    QLabel *activityLabel;
    QLabel *statusMessageLabel;

    QTextBrowser *tmpPresenceBrowser;

    QPushButton *connectButton;
    QPushButton *disconnectButton;

    QXmppClient *xmppClient;
    GlobalObject *globalObj;
};

#endif // GENERALMODULE_H
