/*
 *   This file is part of AkariXB
 *   Copyright 2015-2018  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "helpers.h"


Helpers::Helpers(QObject *parent) : QObject(parent)
{
    // Unnecessary
}


Helpers::~Helpers()
{
    // Unnecessary
}


bool Helpers::isValidJid(QString jid)
{
    // Matching something@something, and only one @ sign
    if (QRegExp("\\S+@\\S+").exactMatch(jid) && jid.count("@") == 1)
    {
        return true;
    }

    return false;
}


QString Helpers::nickFromRoomJid(QString jid)
{
    QStringList jidParts = jid.split("/");
    jidParts.removeFirst();

    return jidParts.join("/");
}


QString Helpers::safeForHtml(QString text)
{
    text.replace("<",  "&lt;");
    text.replace(">",  "&gt;");
    text.replace("\n", "<br>");

    return text;
}


/*
 * Random string from a string list
 */
QString Helpers::randomString(QStringList stringList)
{
    QString chosenString;

    if (!stringList.isEmpty())
    {
        int choice = qrand() % stringList.length();
        if (choice < stringList.length()) // For safety
        {
            chosenString = stringList.at(choice);
        }
    }

    return chosenString;
}

/*
 * Create a reduced list of strings from a full one
 *
 */
QStringList Helpers::someStrings(QStringList stringList, int percent)
{
    if (stringList.isEmpty())
    {
        return QStringList();
    }

    QStringList chosenStrings;

    int minimumCount = (stringList.size() * percent) / 100;
    minimumCount = qMax(minimumCount, 1);

    int stringCount = 0;
    while (stringCount < minimumCount)
    {
        const QString string = randomString(stringList);
        chosenStrings.append(string);
        stringList.removeAll(string);

        ++stringCount;
    }

    return chosenStrings;
}


/*
 * Random number between 2 numbers
 *
 */
int Helpers::randomBetween(int lowNum, int highNum)
{
    if (lowNum > highNum)
    {
        qSwap(lowNum, highNum);
    }

    highNum -= lowNum;

    int randomNumber = qrand() % (highNum + 1);
    randomNumber += lowNum;


    return randomNumber;
}


/*
 * Random probability, depending on how high the chance percentage is.
 *
 */
bool Helpers::probability(int chancePercent)
{
    const int randomNumber = qrand() % 100; // Random between 0 and 100

    if (randomNumber < chancePercent)
    {
        return true;
    }

    return false;
}


