/*
 *   This file is part of AkariXB
 *   Copyright 2015-2018  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef CONFIGDIALOG_H
#define CONFIGDIALOG_H

#include <QWidget>
#include <QIcon>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QFormLayout>
#include <QTabWidget>
#include <QCheckBox>
#include <QSpinBox>
#include <QPushButton>
#include <QAction>
#include <QSettings>

#include <QDebug>


#include "globalobject.h"
#include "stringlistwidget.h"


class ConfigDialog : public QWidget
{
    Q_OBJECT

public:
    explicit ConfigDialog(GlobalObject *globalObject,
                          QWidget *parent = 0);
    ~ConfigDialog();


signals:


public slots:
    void saveSettings();


private:
    QVBoxLayout *mainLayout;
    QTabWidget *tabWidget;

    QWidget *generalOptionsWidget;
    QFormLayout *generalOptionsLayout;
    StringListWidget *adminJidListWidget;
    QLineEdit *commandPrefixLineEdit;
    QSpinBox *keepAliveTimeoutSpinbox;
    QSpinBox *keepAliveIntervalSpinbox;


    QWidget *notificationOptionsWidget;
    QFormLayout *notificationOptionsLayout;
    QCheckBox *notifyNewChatsCheckbox;
    QCheckBox *notifyDisconnectionCheckbox;


    QWidget *systrayOptionsWidget;
    QFormLayout *systrayOptionsLayout;
    QCheckBox *hideWindowCheckbox;


    QHBoxLayout *buttonsLayout;
    QPushButton *saveButton;
    QPushButton *cancelButton;

    QAction *cancelAction;

    GlobalObject *globalObj;
};

#endif // CONFIGDIALOG_H
