/*
 *   This file is part of AkariXB
 *   Copyright 2015-2016  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef STRINGLISTWIDGET_H
#define STRINGLISTWIDGET_H

#include <QWidget>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QListWidget>
#include <QToolButton>
#include <QInputDialog>

#include <QDebug>


class StringListWidget : public QWidget
{
    Q_OBJECT

public:
    explicit StringListWidget(QWidget *parent = 0);
    ~StringListWidget();

    void clearList();
    void addStringsToList(QStringList stringList);
    QStringList getStringsFromList();


signals:


public slots:
    void addToList();
    void editItem();
    void removeFromList();


private:
    QHBoxLayout *mainLayout;
    QListWidget *listWidget;

    QVBoxLayout *buttonsLayout;
    QToolButton *addButton;
    QToolButton *editButton;
    QToolButton *removeButton;

};

#endif // STRINGLISTWIDGET_H
