/*
 *   This file is part of AkariXB
 *   Copyright 2015-2016  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "stringlistwidget.h"


StringListWidget::StringListWidget(QWidget *parent) : QWidget(parent)
{
    this->listWidget = new QListWidget(this);

    this->addButton = new QToolButton(this);
    addButton->setIcon(QIcon::fromTheme("list-add",
                                        QIcon(":/images/list-add.png")));
    connect(addButton, SIGNAL(clicked()),
            this, SLOT(addToList()));


    this->editButton = new QToolButton(this);
    editButton->setIcon(QIcon::fromTheme("document-edit",
                                         QIcon(":/images/button-edit.png")));
    connect(editButton, SIGNAL(clicked()),
            this, SLOT(editItem()));


    this->removeButton = new QToolButton(this);
    removeButton->setIcon(QIcon::fromTheme("list-remove",
                                           QIcon(":/images/list-remove.png")));
    connect(removeButton, SIGNAL(clicked()),
            this, SLOT(removeFromList()));


    // Layout
    this->buttonsLayout = new QVBoxLayout();
    buttonsLayout->addWidget(addButton);
    buttonsLayout->addWidget(editButton);
    buttonsLayout->addSpacing(4);
    buttonsLayout->addWidget(removeButton);
    buttonsLayout->addStretch();

    this->mainLayout = new QHBoxLayout();
    mainLayout->setContentsMargins(0, 0, 0, 0);
    mainLayout->addWidget(listWidget);
    mainLayout->addLayout(buttonsLayout);
    this->setLayout(mainLayout);

    qDebug() << "StringListWidget created";
}


StringListWidget::~StringListWidget()
{
    qDebug() << "StringListWidget destroyed";
}


void StringListWidget::clearList()
{
    for (int counter = 0; counter < listWidget->count(); ++counter)
    {
        delete listWidget->item(counter);
    }

    this->listWidget->clear();
}


void StringListWidget::addStringsToList(QStringList stringList)
{
    this->listWidget->addItems(stringList);
}


QStringList StringListWidget::getStringsFromList()
{
    QStringList stringList;

    for (int counter = 0; counter < listWidget->count(); ++counter)
    {
        stringList.append(listWidget->item(counter)->text());
    }

    return stringList;
}


//////////////////////////////////////////////////////////////////////////////
///////////////////////////////////// SLOTS //////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


void StringListWidget::addToList()
{
    QString newString = QInputDialog::getText(this,
                                              tr("Enter text"),
                                              tr("Enter a new line of text "
                                                 "for the list") // kinda TMP
                                              + "\n\n");
    newString = newString.trimmed();

    if (!newString.isEmpty())
    {
        this->listWidget->addItem(newString);
    }
}


void StringListWidget::editItem()
{
    qDebug() << "EDITING; TODO"; // FIXME
}


void StringListWidget::removeFromList()
{
    int row = this->listWidget->currentRow();

    if (row != -1)
    {
        QListWidgetItem *item = this->listWidget->takeItem(row);
        delete item;
    }
}

