/*
 *   This file is part of AkariXB
 *   Copyright 2015-2016  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "helpers.h"


Helpers::Helpers(QObject *parent) : QObject(parent)
{
    // Unnecessary
}


Helpers::~Helpers()
{
    // Unnecessary
}


bool Helpers::isValidJid(QString jid)
{
    // Matching something@something, and only one @ sign
    if (QRegExp("\\S+@\\S+").exactMatch(jid) && jid.count("@") == 1)
    {
        return true;
    }

    return false;
}


QString Helpers::nickFromRoomJid(QString jid)
{
    QStringList jidParts = jid.split("/");
    jidParts.removeFirst();

    return jidParts.join("/");
}


QString Helpers::safeForHtml(QString text)
{
    text.replace("<",  "&lt;");
    text.replace(">",  "&gt;");
    text.replace("\n", "<br>");

    return text;
}


