/*
 *   This file is part of AkariXB
 *   Copyright 2015-2016  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef GLOBALOBJECT_H
#define GLOBALOBJECT_H

#include <QObject>
#include <QSettings>
#include <QStringList>

#include <QDebug>

#include <QXmppClient.h>
#include <QXmppMucManager.h>


class GlobalObject : public QObject
{
    Q_OBJECT

public:
    explicit GlobalObject(QObject *parent = 0);
    ~GlobalObject();


    // General settings
    void syncGeneralSettings(QStringList newAdminJids,
                             QString newCommandPrefix);
    QStringList getAdminJids();
    QString getCommandPrefix();

    // Notification settings
    void syncNotificationSettings();

    // Systray settings
    void syncSystraySettings();


    //////////


    void setXmppClient(QXmppClient *client);
    QXmppClient *getXmppClient();

    void setMucManager(QXmppMucManager *mucManager);
    QXmppMucManager *getMucManager();

    void setDataDirectory(QString path);
    QString getDataDirectory();

    void addToLog(QString message, bool inStatusBar=true);

    void setConnected(bool state);
    bool connectedToServer();

    void addJoinedRoom(QString roomJid);
    void removeJoinedRoom(QString roomJid);
    QStringList getJoinedRooms();


signals:
    void logMessage(QString message);
    void showInStatusBar(QString message);


public slots:


private:
    QXmppClient *xmppClient;
    QXmppMucManager *xmppMucManager;

    QString dataDirectory;

    bool userConnected;

    QStringList joinedRooms;



    // General options
    QStringList adminJids;
    QString commandPrefix;


    // Notification options


    // Systray options


};

#endif // GLOBALOBJECT_H
