/*
 *   This file is part of AkariXB
 *   Copyright 2015-2016  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "configdialog.h"


ConfigDialog::ConfigDialog(GlobalObject *globalObject,
                           QWidget *parent) : QWidget(parent)
{
    this->setWindowTitle(tr("Program Configuration") + " - AkariXB");
    this->setWindowIcon(QIcon::fromTheme("configure",
                                         QIcon(":/images/button-configure.png")));
    this->setWindowFlags(Qt::Dialog);
    this->setWindowModality(Qt::WindowModal);
    this->setMinimumSize(440, 320);

    this->globalObj = globalObject;


    // Tab 1: General options
    this->adminJidListWidget = new StringListWidget(this);
    adminJidListWidget->addStringsToList(globalObj->getAdminJids());

    this->commandPrefixLineEdit = new QLineEdit(globalObj->getCommandPrefix(),
                                                this);


    this->generalOptionsLayout = new QFormLayout();
    generalOptionsLayout->addRow(tr("Administrator JIDs"),
                                 adminJidListWidget);
    generalOptionsLayout->addRow(tr("Command prefix"),
                                 commandPrefixLineEdit);


    this->generalOptionsWidget = new QWidget(this);
    generalOptionsWidget->setLayout(generalOptionsLayout);


    // Tab 2: Notification options
    this->notifyNewChatsCheckbox = new QCheckBox(this);


    this->notificationOptionsLayout = new QFormLayout();
    notificationOptionsLayout->addRow(tr("Notify new chats"),
                                      notifyNewChatsCheckbox);

    this->notificationOptionsWidget = new QWidget(this);
    notificationOptionsWidget->setLayout(notificationOptionsLayout);



    // Tab 3: System tray options
    this->hideWindowCheckbox = new QCheckBox(this);


    this->systrayOptionsLayout = new QFormLayout();
    systrayOptionsLayout->addRow(tr("Hide window on startup"),
                                 hideWindowCheckbox);

    this->systrayOptionsWidget = new QWidget(this);
    systrayOptionsWidget->setLayout(systrayOptionsLayout);



    // Tab widget
    this->tabWidget = new QTabWidget(this);
    tabWidget->addTab(generalOptionsWidget,
                      QIcon::fromTheme("preferences-other",
                                       QIcon(":/images/button-configure.png")),
                      tr("General"));

    tabWidget->addTab(notificationOptionsWidget,
                      QIcon::fromTheme("preferences-desktop-notification",
                                       QIcon(":/images/button-online.png")),
                      tr("Notifications"));

    tabWidget->addTab(systrayOptionsWidget,
                      QIcon::fromTheme("configure-toolbars",
                                       QIcon(":/images/button-configure.png")),
                      tr("System Tray"));


    this->saveButton = new QPushButton(QIcon::fromTheme("document-save",
                                                        QIcon(":/images/button-save.png")),
                                       tr("&Save"),
                                       this);
    connect(saveButton, SIGNAL(clicked()),
            this, SLOT(saveSettings()));


    this->cancelButton = new QPushButton(QIcon::fromTheme("dialog-cancel",
                                                          QIcon(":/images/button-cancel.png")),
                                         tr("Cancel"),
                                         this);
    connect(cancelButton, SIGNAL(clicked()),
            this, SLOT(hide()));


    this->cancelAction = new QAction(this);
    cancelAction->setShortcut(QKeySequence(Qt::Key_Escape));
    connect(cancelAction, SIGNAL(triggered()),
            this, SLOT(hide()));
    this->addAction(cancelAction);


    // Layout
    this->buttonsLayout = new QHBoxLayout();
    buttonsLayout->setAlignment(Qt::AlignRight);
    buttonsLayout->addWidget(saveButton);
    buttonsLayout->addWidget(cancelButton);

    this->mainLayout = new QVBoxLayout();
    mainLayout->addWidget(tabWidget);
    mainLayout->addLayout(buttonsLayout);
    this->setLayout(mainLayout);

    qDebug() << "ConfigDialog created";
}


ConfigDialog::~ConfigDialog()
{
    qDebug() << "ConfigDialog created";
}



//////////////////////////////////////////////////////////////////////////////
///////////////////////////////////// SLOTS //////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



void ConfigDialog::saveSettings()
{
    QSettings settings;
    settings.beginGroup("Configuration");


    settings.setValue("adminJids",
                      this->adminJidListWidget->getStringsFromList());
    settings.setValue("commandPrefix",
                      this->commandPrefixLineEdit->text().trimmed());
    this->globalObj->syncGeneralSettings(this->adminJidListWidget->getStringsFromList(),
                                         this->commandPrefixLineEdit->text().trimmed());


    this->globalObj->syncNotificationSettings();

    this->globalObj->syncSystraySettings();


    settings.endGroup();
    settings.sync();
    this->hide();
}
