##  Akari XMPP Bot
##  Copyright 2015-2016  JanKusanagi JRR <jancoding@gmx.com>
##
##  This program is free software; you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation; either version 2 of the License, or
##  (at your option) any later version.
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##  You should have received a copy of the GNU General Public License
##  along with this program; if not, write to the
##  Free Software Foundation, Inc.,
##  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
##
## -------------------------------------------------
## Project created by QtCreator
## -------------------------------------------------

message("Generating Makefile for AkariXB... $$escape_expand(\\n)\
Using $$_FILE_$$escape_expand(\\n)")

QT       += core gui network

greaterThan(QT_MAJOR_VERSION, 4) {
    message("Building with Qt 5: v$$QT_VERSION $$escape_expand(\\n)")
    QT += widgets
}


lessThan(QT_MAJOR_VERSION, 5) {
    message("Building with Qt 4: v$$QT_VERSION")
    message("Using QJSON")
    LIBS += -lqjson
}



TARGET = akarixb
TEMPLATE = app

LIBS += -lqxmpp


SOURCES += src/main.cpp\
        src/mainwindow.cpp \
    src/connectiondialog.cpp \
    src/messagehandler.cpp \
    src/configdialog.cpp \
    src/globalobject.cpp \
    src/commandhandler.cpp \
    src/chatwidget.cpp \
    src/helpers.cpp \
    src/chatmodule.cpp \
    src/commandmodule.cpp \
    src/logmodule.cpp \
    src/roommodule.cpp \
    src/activitymodule.cpp \
    src/conversationmodule.cpp \
    src/stringlistwidget.cpp \
    src/datafile.cpp \
    src/generalmodule.cpp

HEADERS  += src/mainwindow.h \
    src/connectiondialog.h \
    src/messagehandler.h \
    src/configdialog.h \
    src/globalobject.h \
    src/commandhandler.h \
    src/chatwidget.h \
    src/helpers.h \
    src/chatmodule.h \
    src/commandmodule.h \
    src/logmodule.h \
    src/roommodule.h \
    src/activitymodule.h \
    src/conversationmodule.h \
    src/stringlistwidget.h \
    src/datafile.h \
    src/generalmodule.h

DISTFILES += \
    README \
    BUGS \
    CHANGELOG \
    INSTALL \
    TODO \
    akarixb.desktop \
    TRANSLATING \
    manual/akarixb.1


TRANSLATIONS += translations/akarixb_es.ts \
    translations/akarixb_ca.ts \
    translations/akarixb_gl.ts \
    translations/akarixb_eu.ts \
    translations/akarixb_fr.ts \
    translations/akarixb_it.ts \
    translations/akarixb_de.ts \
    translations/akarixb_pt.ts \
    translations/akarixb_ru.ts \
    translations/akarixb_EMPTY.ts

RESOURCES += akarixb.qrc


## This is here so the makefile has a 'make install' target
target.path = /usr/bin/
INSTALLS += target


INCLUDEPATH += /usr/include/qxmpp


message("$$escape_expand(\\n\\n\\n)\
Makefile done!$$escape_expand(\\n\\n)\
If you're building the binary, you can run 'make' now. $$escape_expand(\\n)")
