#! /usr/bin/perl -w
use strict;

####################################################################################
# Copyright 2010 Roland Rodrigus
#
# This file is part of afppowertools.
#
#   afppowertools is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   afppowertools is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with afppowertools.  If not, see <http://www.gnu.org/licenses/>.
#####################################################################################

use AFP::PowerTools;
use AFP::PowerTools::Parser;
use AFP::PowerTools::Generator;
use AFP::PowerTools::Objects;

use Getopt::Std;
my $opts = {};
getopts 'i:o:', $opts;

my $usage = "Converts a yaml (as dumped by afp_yamldump.pl) to an AFP resource\nUsage:\n\t$0 -i input.yml -o output.afp\n";
if (! $opts->{i} || ! $opts->{o}){print $usage; exit 1}

open OUT, ">" . $opts->{o} or die "$usage";


use YAML qw(LoadFile);
my @prettys = YAML::LoadFile($opts->{i});
for my $pretty (@prettys){
	print OUT struct2AFP(make_struct("structured_field", $pretty->[0]->{id}, pretty2easy($pretty)));
}

close OUT;
