#! /usr/bin/perl -w

####################################################################################
# Copyright 2010 Roland Rodrigus
#
# This file is part of afppowertools.
#
#   afppowertools is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   afppowertools is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with afppowertools.  If not, see <http://www.gnu.org/licenses/>.
#####################################################################################

use strict;
use AFP::PowerTools::Parser;

my %TLEs;
my @columns = qw(Addr_Unique DestId Norep DestName DestAddress);

my $field_separator = "\t";

my $load_TLE = sub {
	my $sf = shift;
	my $tle_name = get_triplet_parameter ($sf->{members}, "FQName", "02", "0b") ;
	my $tle_value = get_triplet_parameter ($sf->{members}, "AttVal", "36") ;
	$TLEs{$tle_name} = $tle_value;
	#printf "%s\t%s\n", $tle_name, $tle_value;
};

my $print_and_reset_tles = sub {
	if (%TLEs){printf "%s\n", join($field_separator, @TLEs{@columns})};
	undef %TLEs;
}; 

my $exit = sub {
	exit 0;
};

my $afpfile = shift or die "give an afp file as argument";
printf "%s\n\n", join ($field_separator, @columns);

my $parser = AFP::PowerTools::Parser->new();
$parser->set_rule(is_SF(qw(IEL EDI)),$print_and_reset_tles);
$parser->set_rule(is_SF("TLE"),$load_TLE);
#$parser->set_rule(is_SF("BDT"), $exit);
$parser->parse_AFP_file($afpfile);

