#! /usr/bin/perl -w
use strict;


####################################################################################
# Copyright 2010 Roland Rodrigus
#
# This file is part of afppowertools.
#
#   afppowertools is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   afppowertools is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with afppowertools.  If not, see <http://www.gnu.org/licenses/>.
#####################################################################################


use AFP::PowerTools;
use AFP::PowerTools::Parser;
use AFP::PowerTools::Generator;
use AFP::PowerTools::Objects;
my $bytestring;


my $obj1 = make_object("page", {AEGName => "AEG_A4P1"} );
$bytestring = object2AFP($obj1);


#open OUT, "> whitepage.afp" or die;
#print OUT $bytestring;

my $items = [ {text=>"TEXT1", posX => "1000", posY => "3000"}, {text=>"TEXT2", posX => "290", posY => "330"}];
my $ptx_structs = [];
for (@{$items}){
	push @{$ptx_structs}, make_PTX($_);
}
my $obj2 = make_object("presentation_text", {}, $ptx_structs);
$bytestring = object2AFP($obj2);

# well, there is already an aeg in the def of the page..
#open OUT, "> presentation_text.res" or die;
#print OUT $bytestring;

my $obj3 = add_structs_to_object($obj1, $obj2, is_SF("EAG"));
$bytestring = object2AFP($obj3);

open OUT, "> page_with_ptx.afp" or die;
print OUT $bytestring;
close OUT;


