#! /usr/bin/perl -w
use strict;
use AFP::PowerTools;
use AFP::PowerTools::Parser;

####################################################################################
# Copyright 2010 Roland Rodrigus
#
# This file is part of afppowertools.
#
#   afppowertools is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   afppowertools is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with afppowertools.  If not, see <http://www.gnu.org/licenses/>.
#####################################################################################




my $page_nr = 1;

my $afpfile = shift or die "give an afp file as argument";


my $new_page = sub { printf "%s\nPage %d:\n", "=" x 80, $page_nr++;};

my $dump_ptx_text = sub {
	my $sf = shift;
	for (@{$sf->{members}}){
		if ($_->{id} eq "da"){
			printf "(encoding: %s) \"%s\"\n", $_->{TRNDATA}->{char_encoding}, get_fixed_parameter($_->{TRNDATA});
		}
	}
};

my $parser = AFP::PowerTools::Parser->new();
$parser->set_rule(is_SF("BPG"),$new_page);
$parser->set_rule(is_SF("PTX"),$dump_ptx_text);
$parser->parse_AFP_file($afpfile);

