#! /usr/bin/perl -w
use strict;

####################################################################################
# Copyright 2010 Roland Rodrigus
#
# This file is part of afppowertools.
#
#   afppowertools is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   afppowertools is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with afppowertools.  If not, see <http://www.gnu.org/licenses/>.
#####################################################################################



use AFP::PowerTools;
use AFP::PowerTools::Parser;
my $parser=AFP::PowerTools::Parser->new(apply_mapping => 1, parse_only => {BRS => 1, ERS => 1} );

mkdir "resources";

my $new_resource = sub {
	my ($sf, $parser) = @_;
	open $parser->{OUTPUT_AFP}, "> " . "resources/" . $parser->{in_resource}->{name} or die;
	no warnings;
	next STRUCTURED_FIELD;
};

my $close_resource = sub {
	my ($sf, $parser) = @_;
	close $parser->{OUTPUT_AFP} or die;
};

my $in_resource = sub {
	my ($sf, $parser) = @_;
	return defined $parser->{in_resource};
};

my $afpfile = shift or die "give an afp file as argument";
$parser->set_rule(is_SF("BRS"), $new_resource);
$parser->set_rule(is_SF("ERS"), $close_resource);
$parser->set_rule($in_resource,$copy_sf);
$parser->parse_AFP_file($afpfile);



