package AFP::PowerTools::Generator;

use warnings;
use strict;
use AFP::PowerTools;
use Exporter 'import';
our @EXPORT = qw(make_struct struct2AFP set_fixed_parameter pretty2easy); 

use Encode;
use Encode::EBCDIC;
use constant DEFAULT_CHAR_ENCODING => "cp500";

sub make_struct {
	# creates a struct from the yaml grammar, with default values unless values are provided in $custom.
	# if values are read from a YAML that is an output of afp2yaml, the (ref to) array must first be converted to a ref to a hash { paramname => paramdecodedvalue }
	# the $custom is the hashref returned by pretty2easy, or you can just give some keys with your values
	my ($kind, $id, $custom) = @_; 	
	my $struct = {};
	$struct->{kind} = $kind;
	if ($kind eq "structured_field"){ $struct->{prefix} = pack "H2", "5a";}
	$struct->{is_parsed} = 1;
	if($kind eq "ptx_cs"){ $struct->{ptxchaining} = 1 }
	$struct->{flags} = pack "H2", "00"; $struct->{reserved2} = pack "H4", "00"; 
	if ($custom->{id} && ($custom->{id} ne $id)){ die "An id is given in the custom argument and it doesn't match the first argument"}
	$struct->{id} = $id; 
	FIXED_PARAMETER: for(@{$grammar->{$kind}->{$struct->{id}}->{parameters}}){
		if ((exists $custom->{$_->{name}}) || ! $_->{optional}){
			my $parameter = { %{$_} }; 
			if (($kind eq "ptx_cs") && ($parameter->{name} eq "TRNDATA")){
				$parameter->{char_encoding} = $custom->{ptx_encoding};
			}
			set_fixed_parameter($parameter, $custom->{$_->{name}});
			$struct->{$_->{name}} = $parameter;
			push @{$struct->{parameters_order}}, $_->{name};
		}
	}
	if ($grammar->{$kind}->{$id}->{rgs}){
		my $rgi = 0; # n'th Repeating Groups 
		$custom->{rgs} ||= [{}];
		for (@{$custom->{rgs}}){
			RG_FIXED_PARAMETER: for (@{$grammar->{$kind}->{$struct->{id}}->{rgs}->{parameters}}) { 
				if ((exists $custom->{rgs}->[$rgi]->{$_->{name}}) || ! $_->{optional}){
					my $parameter = { %{$_} }; 
					set_fixed_parameter($parameter, $custom->{rgs}->[$rgi]->{$_->{name}});
					$struct->{rgs}->[$rgi]->{$_->{name}} = $parameter;
					push @{$struct->{rgs}->[$rgi]->{parameters_order}}, $_->{name};
				}
			}
			RG_TRIPLET: for (@{$_->{members}}){
				push (@{$struct->{rgs}->[$rgi]->{members}}, make_struct("triplet", $_->{id}, $_));
			}
			$rgi++;
		}
	}
	my $member_kind = ($struct->{id} eq "d3ee9b") ? "ptx_cs" : "triplet";
	$struct->{members} = [];
	for (@{$custom->{members}}){
		push (@{$struct->{members}}, make_struct($member_kind, $_->{id}, $_));
	}
	if ($struct->{id} eq "d3ee9b"){
		$struct->{members}->[0]->{prefix} = pack "H*", $grammar->{meta}->{ptx_cs}->{prefix}->{value};
		$struct->{members}->[$#{$struct->{members}}]->{ptxchaining} = 0;
	}
	return $struct;
}

sub struct2AFP {
	my $struct = shift;
	if (! $struct->{is_parsed}){ return $struct->{prefix} . $struct->{header} . $struct->{unparsed_data}; }
	my $bytestring = "";
	for (@{$struct->{parameters_order}}){
		$bytestring .= $struct->{$_}->{encoded_value};
	}
	for my $rg (@{$struct->{rgs}}){
		for (@{$rg->{parameters_order}}){
			$bytestring .= $rg->{$_}->{encoded_value};
		}
		for (@{$rg->{members}}){
			$bytestring .= struct2AFP($_);
		}
	}
	for (@{$struct->{members}}){
		$bytestring .= struct2AFP($_);
	}
	$struct->{size} = length ($bytestring) + $grammar->{meta}->{$struct->{kind}}->{header}->{size} ;
	$struct->{header} = pack $grammar->{meta}->{$struct->{kind}}->{header}->{format}, @{$struct}{@{$grammar->{meta}->{$struct->{kind}}->{header}->{fields}}};
	if (($struct->{kind} eq "ptx_cs") && $struct->{ptxchaining}){
		vec($struct->{header}, 8, 1) = 1; # perldoc -f vec: if bits less than 4, bytes are unpacked big-endian, then bits are unpacked little-indian
	}
	return (($struct->{prefix} || "") . $struct->{header} . $bytestring);
}


sub set_fixed_parameter {
        my ($parameter, $new_value) = @_;
	my $size = $parameter->{size} || 0;
	$new_value = (exists $parameter->{fixed_value}) ?
		$parameter->{fixed_value} :
		((defined $new_value) && ($parameter->{name} !~ /Reserved/)) ? 
			$new_value : 
			$parameter->{default_value};
        if ($parameter->{type} eq "CODE") {
                $parameter->{decoded_value} = $new_value || "00" x $size;
                return $parameter->{encoded_value} =  pack "H*", $parameter->{decoded_value};
        }
        if ($parameter->{type} eq "CHAR") {
                $parameter->{decoded_value} = (defined $new_value) ? $new_value : ( " " x $size );
		if ($parameter->{decoded_value} eq "X'FFFF'"){ return $parameter->{encoded_value} = pack "H*", "ffffffffffffffff";}
                my $encoding = $parameter->{char_encoding} || DEFAULT_CHAR_ENCODING;
                return $parameter->{encoded_value} = "" . encode $encoding, $parameter->{decoded_value};
        }
        if ($parameter->{type} eq "BITS") {
                $parameter->{decoded_value} = $new_value || "00000000" x $parameter->{size};
                return $parameter->{encoded_value} = pack "B*", $parameter->{decoded_value},
        }
        if ($parameter->{type} eq "UBIN") {
                $parameter->{decoded_value} = $new_value || 0;
                return $parameter->{encoded_value} = substr (pack ("N", $parameter->{decoded_value}), (4 - $parameter->{size}));
        }
        if ($parameter->{type} eq "SBIN") {
                $parameter->{decoded_value} = $new_value || 0;
                if ($parameter->{decoded_value} < 0){
                        return $parameter->{encoded_value} = substr pack ("N", 256**4 + $parameter->{decoded_value}), (4 - $parameter->{size});
                } else {
                        return $parameter->{encoded_value} = substr (pack ("N", $parameter->{decoded_value}), (4 - $parameter->{size}));
                }
        }
	if ($parameter->{type} eq "KEYWORDS"){
		$parameter->{decoded_value} = $new_value;
		my $bytestring = "";
		for (sort keys %{$parameter->{decoded_value}}){
			$bytestring .= pack "H2H2", $_, $parameter->{decoded_value}->{$_};
		}
		my $findelaliste = "debug";
		return $parameter->{encoded_value} = $bytestring;
	}
        die "unkonwn type $parameter->{type}";
}

sub pretty2easy {
        my $pretty = shift;
        my $easy = {};
        for (@{$pretty}){
                %{$easy} = (%{$easy}, %{$_});
        }
        if ($easy->{rgs}){
                my @arr = @{$easy->{rgs}};
                $easy->{rgs} = [];
                my $rgi = 0;
                for (@arr){
                        $easy->{rgs}->[$rgi] = {};
                        for (@{$_}){
                                %{$easy->{rgs}->[$rgi]} = (%{$easy->{rgs}->[$rgi]}, %{$_});
                        }
                        my $members = $easy->{rgs}->[$rgi]->{triplets};
                        for (@{$members}){
                                push @{$easy->{rgs}->[$rgi]->{members}}, pretty2easy($_);
                        }
                        delete $easy->{rgs}->[$rgi]->{triplets};
                        $rgi++;
                }
        }
        my $members = $easy->{triplets} || $easy->{ptx_sequences};
        for (@{$members}){
                push @{$easy->{members}}, pretty2easy($_);
        }
        delete $easy->{triplets};
        delete $easy->{ptx_sequences};
        return $easy;
}

=head1 NAME

AFP::PowerTools::Generator - Create a Structured Field and convert it to a binary string 

=head1 VERSION

Version 0.02

=cut

our $VERSION = '0.02';




=head1 AUTHOR

Roland Rodrigus, C<< <roland.rodrigus at skynet.be> >>



=head1 LICENSE AND COPYRIGHT

   Copyright (C) 2010 Roland Rodrigus

   This file is part of afppowertools.

   afppowertools is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   afppowertools is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with afppowertools.  If not, see <http://www.gnu.org/licenses/>.

=cut

1; # End of AFP::PowerTools::Parser
