package AFP::PowerTools;

use warnings;
use strict;
use 5.005;

our $yamls_dir = "/usr/share/afppowertools";
use Exporter 'import';
our @EXPORT = qw($yamls_dir $grammar $config %sf_acronym2id %sf_id2acronym %ptxcs_id2acronym %ptxcs_acronym2id);
use YAML qw(LoadFile);
our ($grammar, $templates, $config, %sf_acronym2id, %sf_id2acronym, %ptxcs_id2acronym, %ptxcs_acronym2id);
for (qw(structured_field triplet ptx_cs state meta object)){
        $grammar->{$_} = YAML::LoadFile ($yamls_dir . "/grammar/afp_" . $_ . "s.yml") or die "cant load yaml definition $_";
}
for (qw(template)){
        $templates->{$_} = YAML::LoadFile ($yamls_dir . "/templates/afp_" . $_ . "s.yml") or die "cant load yaml definition $_";
}
for (qw(codepage_encodings afp_system_defaults control_codes formdefs output_lines tabfile)){
        $config->{$_} = YAML::LoadFile ($yamls_dir . "/config/" . $_ . ".yml") or die "cant load yaml definition $_";
}



for (keys %{$grammar->{structured_field}}){
        $sf_id2acronym{$_} = $grammar->{structured_field}->{$_}->{acronym};
}
%sf_acronym2id = reverse %sf_id2acronym;

for (keys %{$grammar->{ptx_cs}}){
        $ptxcs_id2acronym{$_} = $grammar->{ptx_cs}->{$_}->{acronym};
}
%ptxcs_acronym2id = reverse %ptxcs_id2acronym;

my $system_defaults = YAML::LoadFile($yamls_dir . "/config/afp_system_defaults.yml");
for my $kind (keys %{$system_defaults}){
	for my $id (keys %{$system_defaults->{$kind}}){
		for my $parameter_name (keys %{$system_defaults->{$kind}->{$id}}){
			for (@{$grammar->{$kind}->{$id}->{parameters}}){
				if($_->{name} eq $parameter_name){
					$_->{default_value} = $system_defaults->{$kind}->{$id}->{$parameter_name};
				}
			}
		}
	}
}
			




=head1 NAME

AFP::PowerTools - Parser/Transformer for AFP (Advanced Function Presentation)

=head1 VERSION

Version 0.02

=cut

our $VERSION = '0.02';



=head1 AUTHOR

Roland Rodrigus, C<< <roland.rodrigus at skynet.be> >>


=head1 LICENSE AND COPYRIGHT

Copyright (C) 2010 Roland Rodrigus

   AFP::PowerTools is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   AFP::PowerTools is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with afppowertools.  If not, see <http://www.gnu.org/licenses/>.



=cut

1; # End of AFP::PowerTools
