from __main__ import pygame, SIL_Engine, exit, Fade, eventmodule
from socket import socket
from menu import SILTxt

#from __future__ import generators

# import Twisted and install
from twisted.internet.threadedselectreactor import install
install()
from twisted.words.protocols import irc
from twisted.internet import reactor, protocol

import sys

import pygame
from pygame.locals import *


# You can customize this if you use your
# own events, but you must OBEY:
#
#   USEREVENT <= TWISTEDEVENT < NUMEVENTS
#
TWISTEDEVENT = USEREVENT

def postTwistedEvent(func):
    # if not using pygame.fastevent, this can explode if the queue
    # fills up.. so that's bad.  Use pygame.fastevent, in pygame CVS
    # as of 2005-04-18.
    eventmodule.post(eventmodule.Event(TWISTEDEVENT, iterateTwisted=func))

def helloWorld():
#    print "hello, world"
    pygame.display.flip()
    reactor.callLater(1, helloWorld)
reactor.callLater(1, helloWorld)

def twoSecondsPassed():
    print "two seconds passed"
reactor.callLater(2, twoSecondsPassed)

def eventIterator():
    while True:
        yield eventmodule.wait()
        while True:
            event = eventmodule.poll()
            if event.type == NOEVENT:
                break
            else:
                yield event

class LogBot(irc.IRCClient):
    """A logging IRC bot."""
    
    nickname = "SILTester"
    
    def connectionMade(self):
        irc.IRCClient.connectionMade(self)
        print "[connected]"

    def connectionLost(self, reason):
        irc.IRCClient.connectionLost(self, reason)
        print "[disconnected]"


    # callbacks for events

    def signedOn(self):
        """Called when bot has succesfully signed on to server."""
        self.join(self.factory.channel)
        global background
        background = pygame.image.load('chat/lobby.png')

    def joined(self, channel):
        """This will get called when the bot joins the channel."""
        global background
        global TextField
        SIL_Engine.SIL_Surface.blit(background,(0,0))
        TextField.blit(SILTxt('*** You have entered the main chat lobby ***',(0,210),13,(255,0,0)).Surface, (0,210))
        SIL_Engine.SIL_Surface.blit(TextField, (21,203))
        print '*** You have entered the main chat lobby ***'

    def privmsg(self, user, channel, msg):
        """This will get called when the bot receives a message."""
        user = user.split('!', 1)[0]
        if channel == "#s1l": drawText(user,msg)
        print "<%s> %s" % (user, msg)
        
        # Check to see if they're sending me a private message
        if channel == self.nickname:
            msg = "It isn't nice to whisper!  Play nice with the group."
            self.msg(user, msg)
            return

        # Otherwise check to see if it is a message directed at me
        if msg.startswith(self.nickname + ":"):
            msg = "%s: I am a log bot" % user
            self.msg(channel, msg)
            print "<%s> %s" % (self.nickname, msg)

    def action(self, user, channel, msg):
        """This will get called when the bot sees someone do an action."""
        user = user.split('!', 1)[0]
        print "* %s %s" % (user, msg)

    # irc callbacks

    def irc_NICK(self, prefix, params):
        """Called when an IRC user changes their nickname."""
        old_nick = prefix.split('!')[0]
        new_nick = params[0]
        print "%s is now known as %s" % (old_nick, new_nick)


class LogBotFactory(protocol.ClientFactory):
    """A factory for LogBots.

    A new protocol instance will be created each time we connect to the server.
    """

    # the class of the protocol to build when new connection is made
    protocol = LogBot

    def __init__(self, userinfo):
        self.channel = "#S1L"
        self.protocol.nickname = userinfo['handle']

    def clientConnectionLost(self, connector, reason):
        """If we get disconnected, reconnect to server."""
        connector.connect()

    def clientConnectionFailed(self, connector, reason):
        print "connection failed:", reason
        reactor.stop()

    def buildProtocol(self, addr):
        self.lastBuiltProtocol = protocol.ClientFactory.buildProtocol(self, addr)
        return self.lastBuiltProtocol

def ircConnect(userinfo):
    global IRCfactory
    # create factory protocol and application
    IRCfactory = LogBotFactory(userinfo)

    # connect factory to this host and port
    reactor.connectTCP("irc.freenode.net", 6667, IRCfactory)

asciis = '\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f 1\'3457\"()8=<_>?)!@#$%^&*(;:,+./2abcdefghijklmnopqrstuvwxyz{|}6-~ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]`\x7f\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f\xa0\xa1\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9\xaa\xab\xac\xad\xae\xaf\xb0\xb1\xb2\xb3\xb4\xb5\xb6\xb7\xb8\xb9\xba\xbb\xbc\xbd\xbe\xbf\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf\xd0\xd1\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xdb\xdc\xdd\xde\xdf\xe0\xe1\xe2\xe3\xe4\xe5\xe6\xe7\xe8\xe9\xea\xeb\xec\xed\xee\xef\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8\xf9\xfa\xfb\xfc\xfd\xfe\xff'

def CHAT_screen():
    global handle, password
    Fade('out')
    SIL_Engine.SIL_Surface.fill((0,0,0))
    SIL_Engine.SIL_Surface.blit(pygame.image.load('chat/login.png').convert_alpha(), (178,93) )

    userinfo = {
                'handle':   str(),
                'password': str()
                }
    global field
    field = 'handle'

    def switchField():
        global field
        if field == 'handle': field = 'password'
        elif field == 'password': field = 'handle'
    
    drawHandle(userinfo['handle'])
    drawPassword(userinfo['password'])

    message = str()
    
    # send an event when twisted wants attention
    reactor.interleave(postTwistedEvent)
    # make shouldQuit a True value when it's safe to quit
    # by appending a value to it.  This ensures that
    # Twisted gets to shut down properly.
    shouldQuit = []
    reactor.addSystemEventTrigger('after', 'shutdown', shouldQuit.append, True)
    
    In_Menu = True
    In_Lobby = False
    while In_Menu == True:
        for event in eventIterator():
            if event.type == TWISTEDEVENT:
                event.iterateTwisted()
                if shouldQuit:
                    break
            elif event.type == QUIT:
                reactor.stop()
            elif event.type == KEYDOWN:
                if In_Lobby == True:
                    if event.key == K_ESCAPE:
                        reactor.stop()
                        In_Lobby = False
                    elif event.key in (K_RETURN, K_KP_ENTER):
                        # Send message
                        global IRCfactory
                        IRCfactory.protocol.msg(IRCfactory.lastBuiltProtocol, IRCfactory.channel, message)
                        drawText(IRCfactory.lastBuiltProtocol.nickname, message)
                        message = str()
                    elif 31 < event.key < 127:
                        key = chr(event.key)
                        mod = event.mod
        
                        if mod in (KMOD_CAPS, KMOD_CAPS+KMOD_LSHIFT, KMOD_CAPS+KMOD_RSHIFT, KMOD_CAPS+KMOD_SHIFT):
                            key = key.upper()
                            mod -= KMOD_CAPS
                            
                        if mod in (KMOD_LSHIFT, KMOD_RSHIFT, KMOD_SHIFT):
                            key = key.translate(asciis)

                        message += key
                        drawInput(message)
                    elif event.key == K_BACKSPACE:
                        message = message[:-1]
                        drawInput(message)
                else:
                    if event.key == K_ESCAPE:
                        reactor.stop()
                        In_Menu = False
                    elif event.key == K_BACKSPACE: userinfo[field] = userinfo[field][:-1]
                    elif event.key == K_TAB: switchField()
                    elif event.key in (K_RETURN, K_KP_ENTER):
                        In_Lobby = True
                        ircConnect(userinfo)
                    elif 31 < event.key < 127:
                        key = chr(event.key)
                        mod = event.mod
        
                        if mod in (KMOD_CAPS, KMOD_CAPS+KMOD_LSHIFT, KMOD_CAPS+KMOD_RSHIFT, KMOD_CAPS+KMOD_SHIFT):
                            key = key.upper()
                            mod -= KMOD_CAPS
                            
                        if mod in (KMOD_LSHIFT, KMOD_RSHIFT, KMOD_SHIFT):
                            key = key.translate(asciis)
                        
                        userinfo[field] += key
                        print userinfo[field]

                    drawHandle(userinfo['handle'])
                    drawPassword(userinfo['password'])               

    from menu import mainScreen
    SIL_Engine.DisplayScreen = mainScreen
    SIL_Engine.DisplayScreen.display()

def drawHandle(handle):
    SIL_Engine.SIL_Surface.fill((0,0,0), (269,288,181,19))
    SILTxt(handle,(273,287),13,(255,0,0)).blit()
    pygame.display.flip()
def drawPassword(password):
    SIL_Engine.SIL_Surface.fill((0,0,0), (269,315,181,19))
    SILTxt('*'*len(password),(273,314),13,(255,0,0)).blit()
    pygame.display.flip()

background = pygame.image.load('chat/lobby.png').convert_alpha()




def drawInput(sendline):
    SIL_Engine.SIL_Surface.fill((0,0,0), (21,432,360,20))
    SILTxt(sendline,(21,430),15,(255,255,255)).blit()
    pygame.display.flip()
    
global TextField
TextField = pygame.Surface((360,360)).convert_alpha()
TextField.fill((255,255,255,0))
#TextField.blit(SILTxt('*** You have entered the main chat lobby ***',(0,210),13,(255,0,0)).Surface, (0,210))
def drawText(nick, text):
    global TextField
    global IRCfactory
    if nick == IRCfactory.protocol.nickname:
        nickcolor = (128,0,0)
        textcolor = (4,76,0)
    else:
        nickcolor = (0,0,255)
        textcolor = (104,164,128)
 ###### Again here...positions?
    nick = SILTxt(nick+':', (0,210), 13, nickcolor, True)
    text = SILTxt(text, (5+nick.Surface.get_width(),210), 13, textcolor).Surface
    temp = TextField.copy()
    TextField.fill((255,255,255,0))
    TextField.blit(temp, (0,-25))
    TextField.blit(nick.Surface, (0,210))
    TextField.blit(text, (5+nick.Surface.get_width(),210))

    SIL_Engine.SIL_Surface.blit(background,(0,0))
    SIL_Engine.SIL_Surface.blit(TextField, (21,203))
