<?php
# Generate styles for graph bars.
#
# Copyright (C) 2018 Ineiev <ineiev--gnu.org>
#
# This file is part of Savane.
#
# Savane is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# Savane is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

require_once('../include/init.php');
require_once('../include/http.php');
require_once('../include/sane.php');
header('Content-Type: text/css');
extract(sane_import('request', array('widths')));

if (preg_match ('/[^.,0123456789]/', $widths))
  $widths = "";

$w = explode (',', $widths);
$count = count ($w);
print "/* This file is generated by Savane, it isn't copyrighable.  */\n";

for ($i = 0; $i < $count; $i++)
  if (strlen ($w[$i]))
    print "div#graph-bar" . $i . " { width: " . $w[$i] . "%; }\n";
?>
