<?php
# Savannah - Menus

# Copyright (C) 1999, 2000 The SourceForge Crew
# Copyright (C) 2005 Sebastian Wieseler
# Copyright (C) 2000-2006 Mathieu Roy <yeupou--gnu.org>
# Copyright (C) 2005, 2006, 2010-2012 Michael J. Flickinger
# Copyright (C) 2014, 2016, 2017 Assaf Gordon
# Copyright (C) 2015-2017 Bob Proulx
# Copyright (C) 2001-2011, 2013, 2017 Sylvain Beucler
# Copyright (C) 2008-2017, 2020 Karl Berry
# Copyright (C) 2013, 2014, 2017-2023 Ineiev <ineiev@gnu.org>
#
# This file is part of Savane.
#
# Code written before 2008-03-30 (commit 8b757b2565ff) is distributed
# under the terms of the GNU General Public license version 3 or (at your
# option) any later version; further contributions are covered by
# the GNU Affero General Public license version 3 or (at your option)
# any later version.  The license notices for the AGPL and the GPL follow.
#
# Savane is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# Savane is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Savane is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# Savane is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

global $HTML;
$HTML->menuhtml_top(_('GNU Project'));
$HTML->menu_entry('//www.gnu.org/help/help.html',_('Help GNU'));
$HTML->menu_entry("//www.gnu.org/software/software.html",_('All GNU Packages'));
$HTML->menu_entry('//www.gnu.org/software/devel.html',_('Dev Resources'));
$HTML->menu_entry('//www.gnu.org/licenses/license-list.html',_('License List'));
$HTML->menu_entry('//www.gnu.org/prep/ftp.html',_('GNU Mirrors'));
$HTML->menuhtml_bottom();

print '<li>';
print '<span class="button">';
print utils_link ('//www.fsf.org/associate/support_freedom/join_fsf?referrer=2442',
                  html_image (
# TRANSLATORS: If Savane has a localized FSF logo in your language, fill its name
# as the "translation" of this string; if it hasn't, repeat the original string
# in your translation.
                              _('thin-image.png'),
                              array('alt' => _('Support freedom')))
                  . "\n<br />"
                  . _('Help us protect your freedom and the rights of computer
users everywhere by becoming a member of the FSF.') . "\n<br /><strong>"
                  . _('Join Now!') . '</strong>');
print "</span>\n";
print "</li>\n\n";

$HTML->menuhtml_top(_('Free Software Foundation'));
$HTML->menu_entry('//www.fsf.org/events/', _('Coming Events'));
$HTML->menu_entry("//www.fsf.org/directory/",
                  _('Free Software Directory'));
$HTML->menu_entry('//savannah.gnu.org/maintenance/SavannahCryptographicRestrictions',
                  _('Cryptographic software legal notice'));
$HTML->menu_entry('//www.fsf.org/about/dmca-notice',
                  _('Copyright infringement notification'));
$HTML->menuhtml_bottom();

$HTML->menuhtml_top(_('Related Forges'));
if (isset ($_SERVER['HTTP_HOST'])
    && $_SERVER['HTTP_HOST'] == 'savannah.gnu.org')
   $HTML->menu_entry('//savannah.nongnu.org/',
                     _('Savannah Non-GNU'));
else
   $HTML->menu_entry('//savannah.gnu.org/',
                     _('GNU Savannah'));
$HTML->menu_entry('//puszcza.gnu.org.ua/',
                  _('Puszcza'));
$HTML->menuhtml_bottom();

# You can create other menus here, following the model above. They will be
# shown in every page. You can also delete the above menu and leave
# this page empty if you want to.
?>
