/*  ADCD - A Diminutive CD player for Linux/GNU
    Copyright (C) 2004-2017 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "msf_time.h"


Msf_time::Msf_time( const int m, const int s, const int f )
  : minute_( m ), second_( s ), frame_( f )
  {
  if( frame_ >= fps ) { second_ += frame_ / fps; frame_ %= fps; }
  else if( frame_ < 0 )
    { int i = (fps - 1 - frame_) / fps; second_ -= i; frame_ += fps * i; }

  if( second_ >= 60 ) { minute_ += second_ / 60; second_ %= 60; }
  else if( second_ < 0 )
    { int i = (59 - second_) / 60; minute_ -= i; second_ += 60 * i; }

  if( minute_ < 0 ) minute_ = second_ = frame_ = 0;
  }


Msf_time & Msf_time::operator+=( const Msf_time & a )
  {
  frame_ += a.frame_; if( frame_ >= fps ) { frame_ -= fps; ++second_; }
  second_ += a.second_; if( second_ >= 60 ) { second_ -= 60; ++minute_; }
  minute_ += a.minute_;
  return *this;
  }


Msf_time & Msf_time::operator-=( const Msf_time & a )
  {
  frame_ -= a.frame_; if( frame_ < 0 ) { frame_ += fps; --second_; }
  second_ -= a.second_; if( second_ < 0 ) { second_ += 60; --minute_; }
  minute_ -= a.minute_;
  if( minute_ < 0 ) minute_ = second_ = frame_ = 0;
  return *this;
  }


bool Msf_time::operator<( const Msf_time & a ) const
  {
  return minute_ < a.minute_ ||
      ( minute_ == a.minute_ && second_ < a.second_ ) ||
      ( minute_ == a.minute_ && second_ == a.second_ && frame_ < a.frame_ );
  }


bool Msf_time::operator>( const Msf_time & a ) const
  {
  return minute_ > a.minute_ ||
      ( minute_ == a.minute_ && second_ > a.second_ ) ||
      ( minute_ == a.minute_ && second_ == a.second_ && frame_ > a.frame_ );
  }
