/*  ADCD - A Diminutive CD player for GNU/Linux
    Copyright (C) 2004, 2005, 2006, 2007, 2009, 2010, 2012, 2013
    Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class CD
  {
  enum Status { no_disc, stopped, paused, playing };
  struct Track_times { Msf_time start, end; };

  int filedes;			// file descriptor
  Status status;
  Msf_time time_abs, time_rel;
  int track_;			// current track
  int first_track_;		// first track on current disc (not always 1)
  int last_track_;		// last track on current disc
  unsigned index_;		// index in playlist
  int loop_;			// Loop mode (0=no_loop, 1=Disc, 2=Track)
  bool linear_;			// Linear / Playlist mode
  std::vector< int > playlist_;
  std::vector< Track_times > timelist;

  CD( const CD & );			// declared as private
  void operator=( const CD & );		// declared as private

public:
  explicit CD( const char * const filename );
  ~CD();

  bool read_status( const bool force = true );

  void close();
  void open();
  void pause();
  void play();
  void stop();

  bool next_track();
  bool prev_track();
  bool seek_forward( const int seconds );
  bool seek_backward( const int seconds );

  int  index() const { return index_; }
  bool linear() const { return linear_; }
  void linear( const bool new_linear ) { linear_ = new_linear; }
  int loop() const { return loop_; }
  void loop( const int new_loop );
  const char * loop_name() const;
  const std::vector< int > & playlist() const { return playlist_; }
  void playlist( const std::vector< int > & pl );
  void show_info() const;
  const char * status_name() const;

  int  first_track() const { return first_track_; }
  int  last_track() const { return last_track_; }
  int  track() const { return track_; }
  bool track( const int new_track, const bool start = false );
  int  tracks() const
    { return (last_track_ > 0) ? last_track_ - first_track_ + 1 : 0; }

  int  volume() const;
  bool volume( int vol ) const;

  enum Time_mode { relative, rem_rel, absolute, rem_abs };
  Msf_time time( const Time_mode mode ) const;
  Msf_time time_start( const int track ) const;
  Msf_time time_end( const int track ) const;
  Msf_time time_track( const int track ) const;
  Msf_time time_disc() const;
  };
