/*  ADCD - A Diminutive CD player for GNU/Linux
    Copyright (C) 2004, 2005, 2006, 2007, 2009, 2010 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class Msf_time			// Non negative time (instant or duration)
  {
  static const int fps = 75;	// Frames per second
  int _minute, _second, _frame;

public:
  Msf_time( const int m = 0, const int s = 0, const int f = 0 ) throw();

  Msf_time & operator+=( const Msf_time & a ) throw();
  Msf_time & operator-=( const Msf_time & a ) throw();
  Msf_time operator+( const Msf_time & a ) const throw()
    { Msf_time r( *this ); r += a; return r; }
  Msf_time operator-( const Msf_time & a ) const throw()
    { Msf_time r( *this ); r -= a; return r; }
  bool operator<( const Msf_time & a ) const throw();
  bool operator>( const Msf_time & a ) const throw();
  bool operator<=( const Msf_time & a ) const throw() { return !(*this > a); }
  bool operator>=( const Msf_time & a ) const throw() { return !(*this < a); }

  int minute() const throw() { return _minute; }
  int second() const throw() { return _second; }
  int frame() const throw() { return _frame; }
  };
