/*  ADCD - A Diminutive CD player for Linux
    Copyright (C) 2004 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/


class Msf_time			// Non negative time (instant or duration)
  {
  static const int fps = 75;	// Frames per second
  int _minute, _second, _frame;

public:
  Msf_time( int m = 0, int s = 0, int f = 0 ) throw();

  Msf_time & operator+=( const Msf_time & a ) throw();
  Msf_time & operator-=( const Msf_time & a ) throw();
  Msf_time operator+( const Msf_time & a ) const throw()
    { Msf_time r( *this ); r += a; return r; }
  Msf_time operator-( const Msf_time & a ) const throw()
    { Msf_time r( *this ); r -= a; return r; }
  bool operator<( const Msf_time & a ) const throw();
  bool operator>( const Msf_time & a ) const throw();
  bool operator<=( const Msf_time & a ) const throw() { return !(*this > a); }
  bool operator>=( const Msf_time & a ) const throw() { return !(*this < a); }

  int minute() const throw() { return _minute; }
  int second() const throw() { return _second; }
  int frame() const throw() { return _frame; }
  };


class CD
  {
  enum Status { no_disc, stopped, paused, playing };
  struct Track_times { Msf_time start, end; };

  int filedes;			// file descriptor
  Status status;
  Msf_time _time_abs, _time_rel;
  int _track;			// current track
  int _first_track;		// first track on current disc (not always 1)
  int _last_track;		// last track on current disc
  size_t _index;		// index in playlist
  bool _linear;			// Linear/Playlist mode
  bool _loop;			// Loop mode
  std::vector< int > _playlist;
  std::vector< Track_times > _timelist;

public:
  CD( const char *filename = "/dev/cdrom" ) throw();
  ~CD() throw();

  bool read_status( bool force = true ) throw();

  void close() throw();
  void open() throw();
  void pause() throw();
  void play() throw();
  void stop() throw();

  bool next_track() throw();
  bool prev_track() throw();
  bool seek_forward( int seconds ) throw();
  bool seek_backward( int seconds ) throw();

  int  index() const throw() { return _index; }
  bool linear() const throw() { return _linear; }
  void linear( bool new_linear ) throw() { _linear = new_linear; }
  bool loop() const throw() { return _loop; }
  void loop( bool new_loop ) throw() { _loop = new_loop; }
  const std::vector< int > & playlist() const throw() { return _playlist; }
  void playlist( const std::vector< int > & pl ) throw();
  char * status_name() const throw();

  int  first_track() const throw() { return _first_track; }
  int  last_track() const throw() { return _last_track; }
  int  track() const throw() { return _track; }
  bool track( int new_track, bool start = false ) throw();
  int  tracks() const throw()
    { return (_last_track > 0) ? _last_track - _first_track + 1 : 0; }

  int  volume() const throw();
  bool volume( int vol ) const throw();

  enum Time_mode { relative, rem_rel, absolute, rem_abs };
  Msf_time time( Time_mode mode ) const throw();
  Msf_time time_begin( int track ) const throw();
  Msf_time time_end( int track ) const throw();
  };
