-- Real editing that encountered an error recovery failure. Fixed by
-- adjusting cost of insert left-paren.

--EMACS_SKIP_UNLESS:(eq ada-parser 'process)
--EMACSCMD:(setq skip-recase-test t)
package body Ada_Mode.Recover_Indent_4 is

   function Current_Indent_Offset
     (Data         : in Parse_Data_Type;
      Anchor_Token : in Semantic_State.Augmented_Token;
      Offset       : in Integer)
     return Integer
   is
      Line_Begin_Pos : constant Buffer_Pos :=
        (if Anchor_Token.First and
           Anchor_Token.First_Indent_Line = Anchor_Token.Line
         then Anchor_Token.Char_Region.First
         else Data.Semantic_State.All_Tokens
           (Data.Semantic_State.Find_Line_Begin
              --  Error here; missing left paren; converting from package.function
              -- (object, args) to object.function (args)
              Anchor_Token.Line, Anchor_Token)).Char_Region.First);
   begin
      return Offset + Integer (Anchor_Token.Char_Region.First - Line_Begin_Pos);
   end Current_Indent_Offset;

end Ada_Mode.Recover_Indent_4;
