/*
**    This file is part of AASM.
**
**    AASM is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 3 of the License, or
**    (at your option) any later version.
**
**    AASM is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with AASM; if not, write to the Free Software
**    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
**    Copyright Alexandre Becoulet, 2002
**    contact : alexandre.becoulet@free.fr
*/

#include "aasm/error.h"

#include "scan.h"
#include "directive.h"

void		directive_warning(const char		*param,
				 struct object_s	*obj)
{
  char			str[MAX_LINE_LEN];

  if (!scan_store(param, NULL, "#%l", str))
    error(ERRTYP_ERROR, "invalid use of .warning directive", 0);
  error_submsg(error(ERRTYP_WARN, ".warning %s", 0), str);
  return;
}

void		directive_error(const char		*param,
			       struct object_s		*obj)
{
  char			str[MAX_LINE_LEN];

  if (!scan_store(param, NULL, "#%l", str))
    error(ERRTYP_ERROR, "invalid use of .error directive", 0);
  error_submsg(error(ERRTYP_ERROR, ".error %s", 0), str);
  return;
}

