<!--
AAMfP: a simple personal kanban metrics spreadsheet

Copyright (C)  2019  Marco Bresciani.

Copying and distribution of this file, with or without modification, are
permitted in any medium without royalty provided the copyright notice
and this notice are preserved. This file is offered as-is, without any
warranty.
-->
# AAMfP: a simple personal kanban metrics spreadsheet
```
 ,' ,-_-. '.
((_/)o o(\_))
 `-'(. .)`-'
     \_/

Copyright (C)  2019  Marco Bresciani.

Copying and distribution of this file, with or without modification, are
permitted in any medium without royalty provided the copyright notice
and this notice are preserved. This file is offered as-is, without any
warranty.
```
## Intro
Improve your daily workflow with this
[LibreOffice](https://www.libreoffice.org/) Calc spreadsheet using the
concepts of [Personal Kanban](http://personalkanban.com/pk/) and
applying some [Kanban
method](https://leankanban.com/project/what-is-km/) flow metrics as
described in the book [Actionable Agile Metrics for
Predictability](https://leanpub.com/actionableagilemetrics) (and
compatible with [Actionable Agile™
Analytics](https://www.actionableagile.com/) tool) by Dan Vacanti.

### Visualize your work
The project contains PDF and ODG (LibreOffice Draw) versions of an
[A3 format](https://en.wikipedia.org/wiki/ISO_216) printable kanban
board with **Backlog**, **Next**, **In-progress** and **Done** columns.
Feel free to print and use it to visualize your workflow and work items!

### Limit your work-in-progress
On top of **Next** and **In-progress** columns of the board (above),
there is a specific **WIP** area inside which you can write the WIP
limit for such columns: remember to write the limit in both columns, to
be sure to properly apply Kanban method concepts and obtain real
improvements.

## Download
Latest release is [v.15.0.0
'酒田'](https://download.savannah.nongnu.org/releases/aamfp/15.0.0/).

See [Downloads](https://download.savannah.nongnu.org/releases/aamfp/)
page for all available releases.

For full versions history and details see the
[CHANGELOG.md](http://hg.savannah.nongnu.org/hgweb/aamfp/file/tip/CHANGELOG.md)
file.

## Contacts
Feel free to open an
[issue](https://savannah.nongnu.org/support/?group=aamfp) for bugs,
enhancements, proposals or tasks. For further questions or requests,
let's keep in touch:
* **[@AAMfP@fosstodon.org](https://fosstodon.org/@AAMfP)** on the
   [Mastodon](https://en.wikipedia.org/wiki/Mastodon_(software)
   federated social network.
* **aamfp_** user (ring:2e5e3ab18b487d096464ed0a0b2c2af468a8838a) on
   the [GNU Jami](https://jami.net) (former GNU Ring, former SFLphone)
   distributed communication platform.

## References
For **Kanban** method starts from here:
[What is Kanban | Lean Kanban](https://leankanban.com/project/wkanban/)
and the [Essential Kanban Condensed 
Guide](https://leankanban.com/guide/).

For **Personal Kanban** starts from here: [Map your work, control your
life: Personal Kanban](http://personalkanban.com/pk/)
and [Personal Kanban: The Book | Personal
Kanban](http://personalkanban.com/pk/book/).

For more details and explanations on metrics please see the book
[Actionable Agile Metrics for
Predictability](https://leanpub.com/actionableagilemetrics) by Vacanti,
Daniel S..

See also **[Kanban One](https://www.kanbanone.com)**, an online tool
aiming to cover the features of this spreadsheet (and more).

## Thanks
Thanks to (in appearing order):

* [Gavi](https://bitbucket.org/classicPintus/) for having solved bug
[#1](https://web.archive.org/web/20190918131734/https://bitbucket.org/marcobresciani/aamfp/issues/1/wrong-cfd-counting)
and for creating **[Kanban One](https://www.kanbanone.com)** together
with Francesco.

* [Samuele Accordini](https://it.linkedin.com/in/samueleaccordini) for
citing this spreadsheet in his LinkedIn article (in Italian) [Personal
Kanban: il trainer del
tempo](https://www.linkedin.com/pulse/personal-kanban-il-trainer-del-tempo-samuele-accordini).

* [Rudiger Wolf](https://bitbucket.org/rnwolf/) for having creating his
  [Pandas Agile Metrics](https://github.com/rnwolf/pandas_agile_metrics)
  project "Inspired by https://bitbucket.org/marcobresciani/aamfp/".

## Appendix

### Copyright Notes
This appendix lists all the copyrightr notes for third parties
components used in this project.

#### Official GPL logo
These images are in the public domain.

See https://www.gnu.org/graphics/license-logos.html.en.

#### Official GFDL logo
Copyright © 2007, 2008, 2011, 2018 Free Software Foundation, Inc.
Available under the GNU Free Documentation License v1.3.

See https://www.gnu.org/graphics/license-logos.html.en.

#### AMYMADE's buttons
AMYMADE's buttons for Definition of Free Cultural Works are in the
public domain as described in
https://freedomdefined.org/Logos_and_buttons#AMYMADE.27s_buttons

#### GNU FreeFont
Both spreadsheet and the printable kanban board use and include **GNU
FreeFont 20120503**.
```
Free UCS scalable fonts is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 3 of the License, or (at
your option) any later version.

The fonts are distributed in the hope that they will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

As a special exception, if you create a document which uses this font,
and embed this font or unaltered portions of this font into the
document, this font does not by itself cause the resulting document to
be covered by the GNU General Public License. This exception does not
however invalidate any other reasons why the document might be covered
by the GNU General Public License. If you modify this font, you may
extend this exception to your version of the font, but you are not
obligated to do so.  If you do not wish to do so, delete this exception
statement from your version.
```
